/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheFile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.SuppressedExceptions;

public class CacheFileStorage
implements AutoCloseable {
    public static final String EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    private final Long2ObjectLinkedOpenHashMap<CacheFile> cache = new Long2ObjectLinkedOpenHashMap();
    private final Path folderPath;
    private final boolean sync;

    CacheFileStorage(Path folderPath, boolean sync) {
        this.folderPath = folderPath;
        this.sync = sync;
    }

    private CacheFile getCacheFile(ChunkPos chunkPos) throws IOException {
        long i = ChunkPos.func_77272_a((int)chunkPos.func_222241_h(), (int)chunkPos.func_222242_i());
        CacheFile cacheFile = (CacheFile)this.cache.getAndMoveToFirst(i);
        if (cacheFile == null) {
            if (this.cache.size() >= 256) {
                ((CacheFile)this.cache.removeLast()).close();
            }
            Files.createDirectories(this.folderPath, new FileAttribute[0]);
            Path path = this.folderPath.resolve("r." + chunkPos.func_222241_h() + "." + chunkPos.func_222242_i() + EXTENSION);
            cacheFile = new CacheFile(path, this.folderPath, this.sync);
            this.cache.putAndMoveToFirst(i, (Object)cacheFile);
        }
        return cacheFile;
    }

    @Nullable
    public CompoundNBT read(ChunkPos chunkPos) throws IOException {
        CompoundNBT tag;
        block6: {
            CompoundNBT tag2;
            CacheFile cacheFile = this.getCacheFile(chunkPos);
            try (DataInputStream chunkDataInputStream = cacheFile.getChunkDataInputStream(chunkPos);){
                if (chunkDataInputStream == null) {
                    tag = null;
                    break block6;
                }
                tag2 = CompressedStreamTools.func_74794_a((DataInput)chunkDataInputStream);
            }
            return tag2;
        }
        return tag;
    }

    protected void write(ChunkPos chunkPos, @Nullable CompoundNBT tag) throws IOException {
        CacheFile cacheFile = this.getCacheFile(chunkPos);
        if (tag == null) {
            cacheFile.clear(chunkPos);
        } else {
            try (DataOutputStream chunkDataInputStream = cacheFile.getChunkDataOutputStream(chunkPos);){
                CompressedStreamTools.func_74800_a((CompoundNBT)tag, (DataOutput)chunkDataInputStream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        SuppressedExceptions collector = new SuppressedExceptions();
        for (CacheFile cacheFile : this.cache.values()) {
            try {
                cacheFile.close();
            }
            catch (IOException e) {
                collector.func_233003_a_((Throwable)e);
            }
        }
        collector.func_233002_a_();
    }

    public void flush() throws IOException {
        for (CacheFile cacheFile : this.cache.values()) {
            cacheFile.flush();
        }
    }
}

