/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.WaypointChat;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;

public class WaypointManagerItem
extends Slot {
    static Integer background = new Color(20, 20, 20).getRGB();
    static Integer backgroundHover = new Color(40, 40, 40).getRGB();
    final FontRenderer fontRenderer;
    final WaypointManager manager;
    int x;
    int y;
    int width;
    int internalWidth;
    Integer distance;
    Waypoint waypoint;
    OnOffButton buttonEnable;
    Button buttonRemove;
    Button buttonEdit;
    Button buttonFind;
    Button buttonTeleport;
    Button buttonChat;
    OnOffButton buttonDeviationEnable;
    int hgap = 4;
    ButtonList buttonListLeft;
    ButtonList buttonListRight;
    int slotIndex;
    SlotMetadata<Waypoint> slotMetadata;
    boolean displayHover = true;
    NumberFormat formatter = new DecimalFormat("0.##E0");

    public WaypointManagerItem(Waypoint waypoint, FontRenderer fontRenderer, WaypointManager manager) {
        boolean id = false;
        this.waypoint = waypoint;
        this.fontRenderer = fontRenderer;
        this.manager = manager;
        SlotMetadata slotMetadata = new SlotMetadata(null, null, null, false);
        String on = Constants.getString("jm.common.on");
        String off = Constants.getString("jm.common.off");
        this.buttonEnable = new OnOffButton(on, off, true, Button.emptyPressable());
        this.buttonEnable.setToggled(waypoint.isEnable());
        this.buttonDeviationEnable = new OnOffButton(on, off, waypoint.showDeviation(), Button.emptyPressable());
        this.buttonFind = new Button(Constants.getString("jm.waypoint.find"));
        this.buttonTeleport = new Button(Constants.getString("jm.waypoint.teleport"));
        this.buttonTeleport.setDrawButton(manager.canUserTeleport);
        this.buttonTeleport.setEnabled(manager.canUserTeleport);
        this.buttonListLeft = new ButtonList(this.buttonEnable, this.buttonFind, this.buttonTeleport);
        if (JourneymapClient.getInstance().getWaypointProperties().showDeviationLabel.get().booleanValue()) {
            this.buttonListLeft.add(this.buttonDeviationEnable);
        }
        this.buttonListLeft.setHeights(manager.rowHeight);
        this.buttonListLeft.fitWidths(fontRenderer);
        this.buttonEdit = new Button(Constants.getString("jm.waypoint.edit"));
        this.buttonRemove = new Button(Constants.getString("jm.waypoint.remove"));
        this.buttonChat = new Button(Constants.getString("jm.waypoint.chat"));
        this.buttonChat.setTooltip(Constants.getString("jm.waypoint.chat.tooltip"));
        this.buttonListRight = new ButtonList(this.buttonChat, this.buttonEdit, this.buttonRemove);
        this.buttonListRight.setHeights(manager.rowHeight);
        this.buttonListRight.fitWidths(fontRenderer);
        this.internalWidth = fontRenderer.func_78256_a("X") * 20 + fontRenderer.func_78256_a(waypoint.getName());
        this.internalWidth += Math.min(manager.colLocation, manager.colName);
        this.internalWidth += this.buttonListLeft.getWidth(this.hgap);
        this.internalWidth += this.buttonListRight.getWidth(this.hgap);
        this.internalWidth += 10;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    protected void drawLabels(MatrixStack mStack, Minecraft mc, int x, int y, Integer color) {
        boolean waypointValid;
        if (this.waypoint == null) {
            return;
        }
        boolean bl = waypointValid = this.waypoint.isEnable() && this.waypoint.isInPlayerDimension();
        if (color == null) {
            color = waypointValid ? this.waypoint.getSafeColor() : 0x808080;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int n = this.manager.rowHeight;
        fr.getClass();
        int yOffset = 1 + (n - 9) / 2;
        fr.func_238405_a_(mStack, this.getDistanceString(), (float)(x + this.manager.colLocation), (float)(y + yOffset), color.intValue());
        boolean disableStrikeThrough = JourneymapClient.getInstance().getWaypointProperties().disableStrikeThrough.get();
        String name = waypointValid || disableStrikeThrough ? this.waypoint.getName() : TextFormatting.STRIKETHROUGH + this.waypoint.getName();
        fr.func_238405_a_(mStack, name, (float)this.manager.colName, (float)(y + yOffset), color.intValue());
    }

    protected void drawWaypoint(MatrixStack mStack, int x, int y) {
        TextureImpl wpTexture = this.waypoint.getTexture();
        DrawUtil.drawColoredImage(mStack, wpTexture, this.waypoint.getIconColor(), 1.0f, x, y - wpTexture.getHeight() / 2, 0.0);
    }

    protected void enableWaypoint(boolean enable) {
        this.buttonEnable.setToggled(enable);
        this.waypoint.setEnable(enable);
    }

    protected int getButtonEnableCenterX() {
        return this.buttonEnable.getCenterX();
    }

    protected int getButtonDeviationX() {
        return this.buttonDeviationEnable.getCenterX();
    }

    protected int getNameLeftX() {
        return this.x + this.manager.getMargin() + this.manager.colName;
    }

    protected int getLocationLeftX() {
        return this.x + this.manager.getMargin() + this.manager.colLocation;
    }

    private String getDistanceString() {
        String distance = String.valueOf(this.getDistance());
        int width = this.fontRenderer.func_78256_a(distance);
        if (width > 35) {
            distance = this.formatter.format(this.getDistance()).toLowerCase(Locale.ROOT);
        }
        return String.format("%sm", distance);
    }

    public boolean clickScrollable(double mouseX, double mouseY) {
        if (this.waypoint == null) {
            return false;
        }
        if (this.buttonChat.mouseOver(mouseX, mouseY)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new WaypointChat(this.waypoint));
            return true;
        }
        if (this.buttonRemove.mouseOver(mouseX, mouseY)) {
            this.manager.removeWaypoint(this);
            this.waypoint = null;
            return true;
        }
        if (this.buttonEnable.mouseOver(mouseX, mouseY)) {
            this.buttonEnable.toggle();
            this.waypoint.setEnable(this.buttonEnable.getToggled());
            if (this.waypoint.isDirty()) {
                WaypointStore.INSTANCE.save(this.waypoint, false);
            }
            return true;
        }
        if (this.buttonDeviationEnable.mouseOver(mouseX, mouseY)) {
            this.buttonDeviationEnable.toggle();
            this.waypoint.setShowDeviation(this.buttonDeviationEnable.getToggled());
            if (this.waypoint.isDirty()) {
                WaypointStore.INSTANCE.save(this.waypoint, false);
            }
            return true;
        }
        if (this.buttonEdit.mouseOver(mouseX, mouseY)) {
            UIManager.INSTANCE.openWaypointEditor(this.waypoint, false, this.manager);
            return true;
        }
        if (this.buttonFind.isEnabled() && this.buttonFind.mouseOver(mouseX, mouseY)) {
            UIManager.INSTANCE.openFullscreenMap(this.waypoint);
            return true;
        }
        if (this.manager.canUserTeleport.booleanValue() && this.buttonTeleport.mouseOver(mouseX, mouseY)) {
            new CmdTeleportWaypoint(this.waypoint).run();
            Fullscreen.state().follow.set(true);
            UIManager.INSTANCE.closeAll();
            return true;
        }
        return false;
    }

    public int getDistance() {
        return this.distance == null ? 0 : this.distance;
    }

    public int getDistanceTo(PlayerEntity player) {
        if (this.distance == null) {
            this.distance = (int)player.func_213303_ch().func_72438_d(this.waypoint.getPosition());
        }
        return this.distance;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public void func_230432_a_(MatrixStack mStack, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        boolean drawHovered;
        Minecraft mc = this.manager.getMinecraft();
        this.width = rowWidth;
        this.x = x;
        this.y = y;
        boolean bl = drawHovered = isMouseOver && this.displayHover;
        if (this.waypoint == null) {
            return;
        }
        this.buttonListLeft.setOptions(true, drawHovered, true);
        this.buttonListRight.setOptions(true, drawHovered, true);
        Integer color = drawHovered ? backgroundHover : background;
        float alpha = drawHovered ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(mStack, this.x, this.y, this.width, this.manager.rowHeight, color, alpha);
        int margin = this.manager.getMargin();
        this.drawWaypoint(mStack, this.x + margin + this.manager.colWaypoint, this.y + this.manager.rowHeight / 2);
        this.drawLabels(mStack, mc, this.x + margin, this.y, null);
        this.buttonTeleport.drawHovered(drawHovered);
        this.buttonFind.drawHovered(drawHovered);
        this.buttonEnable.drawHovered(drawHovered);
        this.buttonDeviationEnable.drawHovered(drawHovered);
        this.buttonRemove.drawHovered(drawHovered);
        this.buttonEdit.drawHovered(drawHovered);
        this.buttonChat.drawHovered(drawHovered);
        this.buttonFind.setEnabled(this.waypoint.isInPlayerDimension());
        this.buttonTeleport.setEnabled(this.waypoint.isTeleportReady());
        this.buttonListRight.layoutHorizontal(x + this.width - margin, y, false, this.hgap).draw(mStack, mouseX, mouseY);
        this.buttonListLeft.layoutHorizontal(this.buttonListRight.getLeftX() - this.hgap * 2, y, false, this.hgap).draw(mStack, mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseEvent) {
        return this.clickScrollable(mouseX, mouseY);
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        return false;
    }

    @Override
    public boolean func_231046_a_(int key, int value, int modifier) {
        return false;
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.buttonEnable.setToggled(this.waypoint.isEnable());
    }

    @Override
    public int getColumnWidth() {
        return this.width;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    @Override
    public void displayHover(boolean enabled) {
        this.displayHover = enabled;
    }

    static class DeviationComparator
    extends Sort {
        public DeviationComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            if (this.ascending) {
                return Boolean.compare(o1.waypoint.showDeviation(), o2.waypoint.showDeviation());
            }
            return Boolean.compare(o2.waypoint.showDeviation(), o1.waypoint.showDeviation());
        }
    }

    static class DistanceComparator
    extends Sort {
        PlayerEntity player;

        public DistanceComparator(PlayerEntity player, boolean ascending) {
            super(ascending);
            this.player = player;
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            double dist1 = o1.getDistanceTo(this.player);
            double dist2 = o2.getDistanceTo(this.player);
            if (this.ascending) {
                return Double.compare(dist1, dist2);
            }
            return Double.compare(dist2, dist1);
        }
    }

    static class NameComparator
    extends Sort {
        public NameComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            if (this.ascending) {
                return o1.waypoint.getName().compareToIgnoreCase(o2.waypoint.getName());
            }
            return o2.waypoint.getName().compareToIgnoreCase(o1.waypoint.getName());
        }
    }

    static abstract class Sort
    implements Comparator<WaypointManagerItem> {
        boolean ascending;

        Sort(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.ascending ? 1 : 0;
        }
    }
}

