/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.impl.BlockInfo;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.RegionCoord;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.FullscreenEventHandler;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BlockInfoLayer
extends Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    BlockPos lastCoord = null;
    PlayerInfoStep playerInfoStep;
    BlockInfoStep blockInfoStep = new BlockInfoStep();
    private boolean isSinglePlayer;
    long lastHover = 0L;
    private final long hoverDelay = 25L;
    private final Minecraft mc;

    public BlockInfoLayer(Fullscreen fullscreen) {
        super(fullscreen);
        this.playerInfoStep = new PlayerInfoStep();
        this.mc = Minecraft.func_71410_x();
        this.isSinglePlayer = this.mc.func_71356_B();
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockPos, float fontScale, boolean isScrolling) {
        long now = Util.func_211177_b();
        Rectangle2D.Double optionsToolbarRect = this.fullscreen.getOptionsToolbarBounds();
        Rectangle2D.Double menuToolbarRect = this.fullscreen.getMenuToolbarBounds();
        if (optionsToolbarRect == null || menuToolbarRect == null) {
            return Collections.emptyList();
        }
        if (now - this.lastHover < 25L) {
            return this.drawStepList;
        }
        if (this.drawStepList.isEmpty()) {
            this.drawStepList.add(this.playerInfoStep);
            this.drawStepList.add(this.blockInfoStep);
        }
        this.playerInfoStep.update(mc.func_228018_at_().func_198105_m() / 2, optionsToolbarRect.getMaxY());
        if (!blockPos.equals((Object)this.lastCoord)) {
            this.getBlockInfo(blockPos, gridRenderer, (String info, BlockInfo.Builder builder) -> {
                FullscreenEventHandler.moveEvent((RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_(), builder.build(), mousePosition);
                this.blockInfoStep.update((String)info, gridRenderer.getWidth() >> 1, menuToolbarRect.getMinY());
            });
        }
        this.lastHover = now;
        return this.drawStepList;
    }

    private void getBlockInfo(BlockPos blockPos, GridRenderer gridRenderer, BiConsumer<String, BlockInfo.Builder> blockInfo) {
        BlockInfo.Builder infoBuilder = new BlockInfo.Builder();
        CompletableFuture.supplyAsync(() -> this.buildBlockInfo(blockPos, gridRenderer, infoBuilder), Util.func_215072_e()).whenCompleteAsync((info, throwable) -> blockInfo.accept((String)info, infoBuilder), Util.func_215072_e());
    }

    private String buildBlockInfo(BlockPos blockPos, GridRenderer gridRenderer, BlockInfo.Builder infoBuilder) {
        this.lastCoord = blockPos;
        ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(blockPos);
        String info = "";
        infoBuilder.withBlockPos(blockPos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(Minecraft.func_71410_x()), gridRenderer.getMapType(), blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(regionCoord, gridRenderer.getMapType());
        Block block = null;
        Biome biome = null;
        if (regionData != null && JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get().booleanValue()) {
            BlockState blockState = regionData.getBlockState(blockPos);
            if (blockState != null) {
                block = blockState.func_177230_c();
                infoBuilder.withBlockState(blockState);
            }
            biome = regionData.getBiome(blockPos);
        }
        if (chunkMD != null && chunkMD.hasChunk() && block == null) {
            BlockMD blockMD = chunkMD.getBlockMD(blockPos.func_177984_a());
            if (blockMD == null || blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(blockPos);
            }
            if (blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(blockPos.func_177977_b());
            }
            if (!blockMD.isIgnore()) {
                block = blockMD.getBlock();
            }
            infoBuilder.withBlockState(blockMD.getBlockState());
            infoBuilder.withChunk(chunkMD.getChunk());
        }
        if (biome == null && this.isSinglePlayer) {
            biome = JmBlockAccess.INSTANCE.getBiome(blockPos);
        }
        String biomeName = "";
        if (block != null) {
            biomeName = BiomeHelper.getTranslatedBiomeName(biome);
        }
        infoBuilder.withChunkPos(new ChunkPos(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4));
        infoBuilder.withBiome(biome);
        infoBuilder.withRegionX(regionCoord.regionX);
        infoBuilder.withRegionZ(regionCoord.regionZ);
        info = this.getBlockInfo(blockPos, biomeName, regionCoord);
        if (block != null) {
            infoBuilder.withBlock(block);
            String blockName = BlockMD.getBlockName(block);
            info = String.format("%s \u25a0 %s", blockName, info);
        }
        return info;
    }

    private String getBlockInfo(BlockPos blockPos, String biomeName, RegionCoord regionCoord) {
        FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        String region = "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
        this.locationFormatKeys = this.locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
        return this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockPos.func_177958_n(), blockPos.func_177952_p(), blockPos.func_177956_o(), blockPos.func_177956_o() >> 4) + " " + biomeName + " " + region;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockCoord, int button, boolean doubleClick, float fontScale) {
        if (button == 1) {
            this.fullscreen.popupMenu.displayBasicOptions(blockCoord);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class BlockInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            this.text = text;
            this.x = x;
            this.y = y - (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScreenScaleFactor();
        }

        @Override
        public void draw(MatrixStack mStack, IRenderTypeBuffer buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showMouseLoc.get().booleanValue()) {
                DrawUtil.drawLabel(mStack, (ITextComponent)Constants.getStringTextComponent(this.text), this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }

    class PlayerInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private String prefix;
        private double x;
        private double y;

        PlayerInfoStep() {
        }

        void update(double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            if (this.prefix == null) {
                this.prefix = ((BlockInfoLayer)BlockInfoLayer.this).mc.field_71439_g.func_200200_C_().getString() + " \u25a0 ";
            }
            this.x = x;
            this.y = y + (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScreenScaleFactor();
        }

        @Override
        public void draw(MatrixStack mStack, IRenderTypeBuffer buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showPlayerLoc.get().booleanValue()) {
                DrawUtil.drawLabel(mStack, (ITextComponent)Constants.getStringTextComponent(this.prefix + Fullscreen.state().playerLastPos), this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }
}

