/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import journeymap.client.Constants;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class TextBox
extends TextFieldWidget {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;
    private long lastClick = 0L;

    public TextBox(Object text, FontRenderer fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBox(Object text, FontRenderer fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height, (ITextComponent)Constants.getStringTextComponent(text.toString()));
        this.func_146203_f(256);
        this.func_146180_a(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void func_146191_b(String par1Str) {
        if (this.numeric) {
            String fixed = par1Str.replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                par1Str = "-".equals(fixed) && this.func_146198_h() != 0 && !this.isAllSelected() ? "" : fixed;
            }
        }
        super.func_146191_b(par1Str);
    }

    public void setText(Object object) {
        super.func_146180_a(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.func_146179_b();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean func_231042_a_(char c, int key) {
        boolean typed = false;
        if (this.func_230999_j_()) {
            typed = super.func_231042_a_(c, key);
            if (this.numeric && typed) {
                this.clamp();
            }
        }
        return typed;
    }

    public boolean func_231046_a_(int key, int value, int modifier) {
        boolean pressed = false;
        if (this.func_230999_j_()) {
            pressed = super.func_231046_a_(key, value, modifier);
        }
        return pressed;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            if (this.func_230999_j_() && button == 0) {
                int i = MathHelper.func_76128_c((double)mouseX) - this.field_230690_l_;
                if (this.func_146181_i()) {
                    i -= 4;
                }
                String s = this.field_146211_a.func_238412_a_(this.func_146179_b().substring(this.field_146225_q), this.func_146200_o());
                this.func_146199_i(this.field_146211_a.func_238412_a_(s, i).length() + this.field_146225_q);
                return true;
            }
            return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_146199_i(super.func_146198_h());
        if (this.func_231047_b_(mouseX, mouseY) && super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            long sysTime = Util.func_211177_b();
            boolean doubleClick = sysTime - this.lastClick < 200L;
            this.lastClick = sysTime;
            if (doubleClick) {
                this.selectAll();
            }
            return true;
        }
        this.func_146195_b(false);
        return false;
    }

    public void func_230996_d_(boolean focused) {
        super.func_230996_d_(focused);
    }

    public void selectAll() {
        this.func_146202_e();
        this.func_146199_i(0);
    }

    public boolean isAllSelected() {
        return this.func_146179_b().equals(this.func_146207_c());
    }

    public void func_212422_f(int position) {
        super.func_212422_f(position);
    }

    public boolean func_230449_g_() {
        return this.field_230692_n_;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.func_146176_q() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.func_230998_h_() + 1;
            int y2 = y1 + this.func_238483_d_() + 1;
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)red);
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)red);
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)red);
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)red);
        }
    }

    public Integer clamp() {
        return this.clamp(this.func_146179_b());
    }

    public Integer clamp(String text) {
        int val;
        if (!this.numeric) {
            return null;
        }
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                val = Math.max(this.clampMin, Integer.parseInt(text));
            }
            catch (Exception e) {
                return this.clampMin;
            }
            if (this.clampMax != null) {
                try {
                    val = Math.min(this.clampMax, val);
                }
                catch (Exception e) {
                    return this.clampMax;
                }
            }
        } else {
            try {
                val = Integer.parseInt(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val != Integer.parseInt(text)) {
            this.setText(val);
        }
        return val;
    }

    public int getX() {
        return this.field_230690_l_;
    }

    public void func_212952_l(int x) {
        this.field_230690_l_ = x;
    }

    public int getY() {
        return this.field_230691_m_;
    }

    public void setY(int y) {
        this.field_230691_m_ = y;
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public void func_230991_b_(int w) {
        this.field_230688_j_ = w;
    }

    public int func_238483_d_() {
        return this.field_230689_k_;
    }

    public void setHeight(int h) {
        this.field_230689_k_ = h;
    }

    public int getCenterX() {
        return this.getX() + this.func_230998_h_() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.func_238483_d_() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.func_238483_d_();
    }

    public int getRightX() {
        return this.getX() + this.func_230998_h_();
    }
}

