/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.mojang.authlib.GameProfile;
import java.util.TreeSet;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;

public class CmdTeleportWaypoint {
    final Minecraft mc = Minecraft.func_71410_x();
    final Waypoint waypoint;

    public CmdTeleportWaypoint(Waypoint waypoint) {
        this.waypoint = waypoint;
    }

    public static boolean isPermitted(Minecraft mc) {
        if (mc.func_71401_C() != null) {
            IntegratedServer mcServer = mc.func_71401_C();
            PlayerList configurationManager = null;
            GameProfile profile = null;
            try {
                profile = new GameProfile(mc.field_71439_g.func_110124_au(), mc.field_71439_g.func_200200_C_().getString());
                configurationManager = mcServer.func_184103_al();
                Journeymap.getLogger().debug("integrated server not null, can send commands: " + configurationManager.func_152596_g(profile) + " is tp enabled: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
                return configurationManager.func_152596_g(profile) || JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (profile != null && configurationManager != null) {
                        Journeymap.getLogger().debug("Some Error happened: " + mcServer.func_71264_H() + " : " + ((IServerWorldInfo)((ServerWorld)mcServer.forgeGetWorldMap().get(mc.field_71439_g.field_70170_p.func_234923_W_())).func_72912_H()).func_76086_u() + " : " + mcServer.func_71214_G().equalsIgnoreCase(profile.getName()));
                        return mcServer.func_71264_H() && ((IServerWorldInfo)((ServerWorld)mcServer.forgeGetWorldMap().get(mc.field_71439_g.field_70170_p.func_234923_W_())).func_72912_H()).func_76086_u() && mcServer.func_71214_G().equalsIgnoreCase(profile.getName());
                    }
                    Journeymap.getLogger().warn("Failed to check teleport permission both ways: " + LogFormatter.toString(e) + ", and profile or configManager were null.");
                }
                catch (Exception e2) {
                    Journeymap.getLogger().warn("Failed to check teleport permission. Both ways failed: " + LogFormatter.toString(e) + ", and " + LogFormatter.toString(e2));
                }
            }
        }
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            Journeymap.getLogger().debug("On a server with JM returning: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
            return JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
        }
        Journeymap.getLogger().debug("On a server without JM returning true by default");
        return true;
    }

    public void run() {
        double x = this.waypoint.getRawCenterX();
        double z = this.waypoint.getRawCenterZ();
        TreeSet dims = (TreeSet)this.waypoint.getDimensions();
        String dim = this.mc.field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString();
        if (!dims.isEmpty()) {
            dim = dims.stream().filter(d -> this.mc.field_71439_g.field_70170_p.func_234923_W_().equals(DimensionHelper.getWorldKeyForName(d))).findFirst().orElse((String)dims.first());
        }
        if (World.field_234919_h_.equals(DimensionHelper.getWorldKeyForName(dim)) && World.field_234919_h_.equals(this.mc.field_71439_g.field_70170_p.func_234923_W_())) {
            x = this.waypoint.getBlockCenteredX();
            z = this.waypoint.getBlockCenteredZ();
        }
        if (World.field_234919_h_.equals(DimensionHelper.getWorldKeyForName(dim)) && !World.field_234919_h_.equals(this.mc.field_71439_g.field_70170_p.func_234923_W_())) {
            x = (double)((int)x >> 3) + (x > 0.0 ? 0.5 : -0.5);
            z = (double)((int)z >> 3) + (z > 0.0 ? 0.5 : -0.5);
        }
        CmdTeleportWaypoint.teleport(x, this.waypoint.getY(), z, dim);
    }

    public static void teleport(BlockPos pos, RegistryKey<World> dim) {
        CmdTeleportWaypoint.teleport(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim != null ? dim.func_240901_a_().toString() : null);
    }

    public static void teleport(double x, int y, double z, String dim) {
        Minecraft mc = Minecraft.func_71410_x();
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() || Minecraft.func_71410_x().func_71356_B()) {
            JourneymapClient.getInstance().getDispatcher().sendTeleportPacket(x, y, z, dim);
        } else {
            String teleportCommand = JourneymapClient.getInstance().getWaypointProperties().teleportCommand.getAsString();
            teleportCommand = teleportCommand.replace("{name}", mc.field_71439_g.func_200200_C_().getString()).replace("{x}", String.valueOf(x)).replace("{y}", String.valueOf(y)).replace("{z}", String.valueOf(z)).replace("{dim}", dim);
            mc.field_71439_g.func_71165_d(teleportCommand);
        }
    }
}

