/*
 * Decompiled with CFR 0.152.
 */
package gg.chaldea.client.reset.packet.mixin;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.IPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.FMLConnectionData;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.Supplier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FMLHandshakeHandler.class})
public class MixinFMLHandshakeHandler {
    @Shadow(remap=false)
    @Final
    static Marker FMLHSMARKER;
    @Shadow(remap=false)
    @Final
    private static Logger LOGGER;
    @Shadow(remap=false)
    private Set<ResourceLocation> registriesToReceive;
    @Shadow(remap=false)
    private Map<ResourceLocation, ForgeRegistry.Snapshot> registrySnapshots;

    @Overwrite(remap=false)
    void handleServerModListOnClient(FMLHandshakeMessages.S2CModList serverModList, java.util.function.Supplier<NetworkEvent.Context> c) {
        LOGGER.debug(FMLHSMARKER, "Logging into server with mod list [{}]", (Object)String.join((CharSequence)", ", serverModList.getModList()));
        c.get().setPacketHandled(true);
        FMLNetworkConstants.handshakeChannel.reply((Object)new FMLHandshakeMessages.C2SModListReply(), c.get());
        LOGGER.debug(FMLHSMARKER, "Accepted server connection");
        c.get().getNetworkManager().channel().attr(FMLNetworkConstants.FML_NETVERSION).set((Object)"FML2");
        c.get().getNetworkManager().channel().attr(FMLNetworkConstants.FML_CONNECTION_DATA).set((Object)new FMLConnectionData(serverModList.getModList(), serverModList.getChannels()));
        this.registriesToReceive = new HashSet<ResourceLocation>(serverModList.getRegistries());
        this.registrySnapshots = Maps.newHashMap();
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Expecting {} registries: {}", new Supplier[]{() -> this.registriesToReceive.size(), () -> this.registriesToReceive});
    }

    @Overwrite(remap=false)
    void handleClientModListOnServer(FMLHandshakeMessages.C2SModListReply clientModList, java.util.function.Supplier<NetworkEvent.Context> c) {
        LOGGER.debug(FMLHSMARKER, "Received client connection with modlist [{}]", (Object)String.join((CharSequence)", ", clientModList.getModList()));
        boolean accepted = NetworkRegistry.validateServerChannels((Map)clientModList.getChannels());
        c.get().getNetworkManager().channel().attr(FMLNetworkConstants.FML_CONNECTION_DATA).set((Object)new FMLConnectionData(clientModList.getModList(), clientModList.getChannels()));
        c.get().setPacketHandled(true);
        if (!accepted) {
            LOGGER.error(FMLHSMARKER, "Terminating connection with client, mismatched mod list");
            c.get().getNetworkManager().func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)new StringTextComponent("Connection closed - mismatched mod channel list")));
            c.get().getNetworkManager().func_150718_a((ITextComponent)new StringTextComponent("Connection closed - mismatched mod channel list"));
        } else {
            LOGGER.debug(FMLHSMARKER, "Accepted client connection mod list");
        }
    }
}

