/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.tileentity.OwnedTileEntity;
import java.text.SimpleDateFormat;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BattleRuleOwnedTileEntity
extends OwnedTileEntity {
    private static final String DECK_SIZE_KEY = "DeckSize";
    private static final String PRIZE_COUNT_KEY = "PrizeCount";
    private static final String STARTING_COMMAND_KEY = "StartingCommand";
    private static final String ENDING_COMMAND_KEY = "EndingCommand";
    private static final String STARTING_MESSAGE_KEY = "StartingMessage";
    private static final String ENDING_MESSAGE_KEY = "EndingMessage";
    private static final String CUSTOM_NAME_KEY = "CustomName";
    private static final String TIME_LIMIT_KEY = "TimeLimit";
    private static final String ELO_MINIMUM_KEY = "EloMinimum";
    private static final String SHADOW_GAME_KEY = "ShadowGame";
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat("HH:mm:ss");
    protected int deckSize = 60;
    protected int prizeCount = 6;
    protected int eloMinimum = 0;
    protected String startingCommand = "";
    protected String endingCommand = "";
    protected String startingMessage = "";
    protected String endingMessage = "";
    private String customName = "@";
    protected int timeLimit = 0;
    protected boolean isShadowGame = false;

    public BattleRuleOwnedTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b(DECK_SIZE_KEY)) {
            this.deckSize = nbt.func_74762_e(DECK_SIZE_KEY);
        }
        if (nbt.func_74764_b(PRIZE_COUNT_KEY)) {
            this.prizeCount = nbt.func_74762_e(PRIZE_COUNT_KEY);
        }
        if (nbt.func_74764_b(TIME_LIMIT_KEY)) {
            this.timeLimit = nbt.func_74762_e(TIME_LIMIT_KEY);
        }
        if (nbt.func_74764_b(ELO_MINIMUM_KEY)) {
            this.eloMinimum = nbt.func_74762_e(ELO_MINIMUM_KEY);
        }
        if (nbt.func_74764_b(STARTING_COMMAND_KEY)) {
            this.startingCommand = nbt.func_74779_i(STARTING_COMMAND_KEY);
        }
        if (nbt.func_74764_b(ENDING_COMMAND_KEY)) {
            this.endingCommand = nbt.func_74779_i(ENDING_COMMAND_KEY);
        }
        if (nbt.func_74764_b(STARTING_MESSAGE_KEY)) {
            this.startingMessage = nbt.func_74779_i(STARTING_MESSAGE_KEY);
        }
        if (nbt.func_74764_b(ENDING_MESSAGE_KEY)) {
            this.endingMessage = nbt.func_74779_i(ENDING_MESSAGE_KEY);
        }
        if (nbt.func_74764_b(CUSTOM_NAME_KEY)) {
            this.customName = nbt.func_74779_i(CUSTOM_NAME_KEY);
        }
        if (nbt.func_74764_b(SHADOW_GAME_KEY)) {
            this.isShadowGame = nbt.func_74767_n(SHADOW_GAME_KEY);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a(DECK_SIZE_KEY, this.deckSize);
        nbt.func_74768_a(PRIZE_COUNT_KEY, this.prizeCount);
        nbt.func_74768_a(TIME_LIMIT_KEY, this.timeLimit);
        nbt.func_74768_a(ELO_MINIMUM_KEY, this.eloMinimum);
        nbt.func_74778_a(STARTING_COMMAND_KEY, this.startingCommand);
        nbt.func_74778_a(ENDING_COMMAND_KEY, this.endingCommand);
        nbt.func_74778_a(STARTING_MESSAGE_KEY, this.startingMessage);
        nbt.func_74778_a(ENDING_MESSAGE_KEY, this.endingMessage);
        nbt.func_74778_a(CUSTOM_NAME_KEY, this.customName);
        nbt.func_74757_a(SHADOW_GAME_KEY, this.isShadowGame);
        return nbt;
    }

    public int trigger(World world, String command, String winnerName, String loserName) {
        if (world.field_72995_K) {
            return 0;
        }
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        TCG.LOGGER.info("Try to trigger \"" + command + "\"");
        if (!command.isEmpty()) {
            String formattedCommand = this.formatCommand(command, winnerName, loserName);
            minecraftServer.func_195571_aL().func_197059_a(minecraftServer.func_195573_aM(), formattedCommand);
        }
        return 0;
    }

    public String formatCommand(String command, String winnerName, String loserName) {
        return command;
    }

    public int getDeckSize() {
        return this.deckSize;
    }

    public void setDeckSize(int deckSize) {
        this.deckSize = deckSize;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getPrizeCount() {
        return this.prizeCount;
    }

    public void setPrizeCount(int prizeCount) {
        this.prizeCount = prizeCount;
    }

    public int getEloMinimum() {
        return this.eloMinimum;
    }

    public void setEloMinimum(int eloMinimum) {
        this.eloMinimum = eloMinimum;
    }

    public String getStartingCommand() {
        return this.startingCommand;
    }

    public void setStartingCommand(String startingCommand) {
        this.startingCommand = startingCommand;
    }

    public String getEndingCommand() {
        return this.endingCommand;
    }

    public void setEndingCommand(String endingCommand) {
        this.endingCommand = endingCommand;
    }

    public String getStartingMessage() {
        return this.startingMessage;
    }

    public void setStartingMessage(String startingMessage) {
        this.startingMessage = startingMessage;
    }

    public String getEndingMessage() {
        return this.endingMessage;
    }

    public void setEndingMessage(String endingMessage) {
        this.endingMessage = endingMessage;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getName() {
        return "BattleBox";
    }

    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public void endGame(PlayerServerState winner, PlayerServerState loser, boolean tiedGame) {
    }

    public boolean isShadowGame() {
        return this.isShadowGame;
    }

    public void setShadowGame(boolean b) {
        this.isShadowGame = b;
    }

    public void toggleShadowGame() {
        this.isShadowGame = !this.isShadowGame;
    }
}

