/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.block.BattleControllerBlock;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.log.DuelLog;
import com.pixelmonmod.tcg.duel.state.CoinFlipState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.RenderState;
import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleRuleOwnedTileEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BattleOwnedTileEntityController
extends BattleRuleOwnedTileEntity
implements ITickableTileEntity {
    protected GameClientState client;
    protected RenderState render;
    protected TCGScreen gui;
    protected boolean init;
    public boolean[] energySelectionForRetreat;
    private Map<Integer, ImmutableCard> showingPrizes = new HashMap<Integer, ImmutableCard>();

    public BattleOwnedTileEntityController() {
        super((TileEntityType)TileEntityRegistration.BATTLE_CONTROLLER.get());
    }

    public void func_73660_a() {
        this.initialize();
    }

    protected void initialize() {
        if (!this.init) {
            this.client = new GameClientState();
            this.render = new RenderState();
            this.energySelectionForRetreat = null;
            this.showingPrizes = new HashMap<Integer, ImmutableCard>();
            this.init = true;
        }
    }

    public float getScale() {
        BattleControllerBlock controller = (BattleControllerBlock)this.func_195044_w().func_177230_c();
        return controller.getScale();
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BattleControllerBlock.FACING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resetClientGame() {
        this.init = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientSideValues(GamePhase gamePhase, int whichPlayerAmI, boolean isMyTurn, PlayerClientMyState myState, PlayerClientOpponentState oppState, DuelLog log, int turnCount, CoinFlipState coinFlip) {
        if (this.client != null) {
            this.client.setGamePhase(gamePhase);
            this.client.setPlayerIndex(whichPlayerAmI);
            this.client.setMyTurn(isMyTurn);
            this.client.setMe(myState);
            this.client.setOpponent(oppState);
            this.client.setLog(log);
            this.client.setTurnCount(turnCount);
            this.client.setCoinFlip(coinFlip);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderClientSideValues(GamePhase gamePhase, int currentTurn, PlayerClientOpponentState[] players) {
        if (this.render != null) {
            this.render.setGamePhase(gamePhase);
            this.render.setCurrentTurn(currentTurn);
            this.render.setPlayers(players);
        }
    }

    public GameClientState getClient() {
        return this.client;
    }

    public RenderState getRender() {
        return this.render;
    }

    public void setGui(TCGScreen gui) {
        this.gui = gui;
    }

    public boolean doesCardListContainCardType(List<ImmutableCard> cards, CardType type) {
        for (ImmutableCard card : cards) {
            if (card.getCardType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean func_183000_F() {
        return false;
    }

    public GameServerState getGameServer() {
        return null;
    }

    public void requestAbility(int playerIndex, BoardLocation location, int locationIndex) {
    }

    public void requestAttack(int playerIndex, int attackIndex) {
    }

    public void requestPickAttack(int playIndex, int attackIndex) {
    }

    public void requestEndTurn(PlayerServerState player) {
    }

    public void playTrainerCard(PlayerServerState player, int cardIndex, ImmutableCard check) {
    }

    public void playPokemonCardToBench(PlayerServerState player, int cardIndex, ImmutableCard check, int bench) {
    }

    public void playCardFromHandToActive(PlayerServerState player, int cardIndex, ImmutableCard check) {
    }

    public void playStadiumCard(PlayerServerState player, int cardIndex, ImmutableCard check) {
    }

    public void setCardSelection(PlayerEntity player, boolean isOpened, boolean[] cardSelection) {
    }

    public void setPrizeSelection(PlayerEntity player, int index) {
    }

    public void requestRetreatAndSwitch(PlayerServerState player, List<CommonCardState> energyPayment, int newActivePos) {
    }

    public void requestSwitch(PlayerServerState player, int newActivePos) {
    }

    public void requestFlip(PlayerServerState player) {
    }

    public void discard(PlayerServerState player, BoardLocation location, int locationSubIndex) {
    }

    public void setCustomGUIResult(PlayerEntity player, boolean isOpened, int[] result) {
    }

    public void revealPrize(int prizeIndex, ImmutableCard prize) {
        this.showingPrizes.put(prizeIndex, prize);
    }

    public Map<Integer, ImmutableCard> getShowingPrizes() {
        return this.showingPrizes;
    }
}

