/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.init.loaders.PixelmonLoaders;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncCardsPacket
extends AbstractTCGPacket {
    private List<ImmutableCard> cards;
    private boolean last;

    public SyncCardsPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private SyncCardsPacket(List<ImmutableCard> cards, boolean last) {
        this();
        this.cards = cards;
        this.last = last;
    }

    public static void sync(ServerPlayerEntity player) {
        List<ImmutableCard> cards = Cards.getAll();
        int groups = Math.max(1, cards.size() / 50);
        int size = cards.size() / groups;
        for (int group = 0; group < groups; ++group) {
            int i;
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < cards.size(); ++i) {
                    sublist.add(cards.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(cards.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncCardsPacket(sublist, group + 1 == groups));
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.cards = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.func_218666_n() + buffer.func_218666_n();
            this.cards.add((ImmutableCard)Cards.GSON.fromJson(json, ImmutableCard.class));
        }
        this.last = buffer.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.cards.size());
        for (ImmutableCard card : this.cards) {
            int length = card.getJson().length() / 2;
            String firstHalf = card.getJson().substring(0, length);
            String secondHalf = card.getJson().substring(length);
            buffer.func_180714_a(firstHalf);
            buffer.func_180714_a(secondHalf);
        }
        buffer.writeBoolean(this.last);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        RegistryManager.invalidateRegistry(ImmutableCard.class);
        for (ImmutableCard card : this.cards) {
            Cards.register(card);
        }
        PixelmonLoaders.tryReloadSearchTrees(this.last);
    }
}

