/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.init.registry;

import com.pixelmonmod.pixelmon.client.models.items.PixelmonISTERs;
import com.pixelmonmod.pixelmon.items.PixelmonBlockItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import com.pixelmonmod.tcg.block.BattleControllerBlock;
import com.pixelmonmod.tcg.block.BattleSpectatorBlock;
import com.pixelmonmod.tcg.block.EssenceJarBlock;
import com.pixelmonmod.tcg.init.registry.ItemRegistration;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="tcg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BlockRegistration {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tcg");
    public static final RegistryObject<Block> SMALL_BATTLE_CONTROLLER = BlockRegistration.registerBlock("small_battle_controller", PixelmonItemGroups.TAB_TCG, () -> new BattleControllerBlock("small_battle_controller", 1.0f));
    public static final RegistryObject<Block> MEDIUM_BATTLE_CONTROLLER = BlockRegistration.registerBlock("medium_battle_controller", PixelmonItemGroups.TAB_TCG, () -> new BattleControllerBlock("medium_battle_controller", 2.0f));
    public static final RegistryObject<Block> LARGE_BATTLE_CONTROLLER = BlockRegistration.registerBlock("large_battle_controller", PixelmonItemGroups.TAB_TCG, () -> new BattleControllerBlock("large_battle_controller", 4.0f));
    public static final RegistryObject<Block> BATTLE_SPECTATOR = BlockRegistration.registerBlock("battle_spectator", PixelmonItemGroups.TAB_TCG, BattleSpectatorBlock::new);
    public static final RegistryObject<Block> ESSENCE_JAR = BlockRegistration.registerBlockWithISTER("essence_jar", PixelmonItemGroups.TAB_TCG, EssenceJarBlock::new, () -> PixelmonISTERs.ESSENCE_JAR_ISTER, new Item.Properties().func_200917_a(1));

    private static <A extends Block, B extends Item> void registerBlockWithCustomItem(String name, Supplier<A> block, Function<A, B> item) {
        RegistryObject result = BLOCKS.register(name, block);
        ItemRegistration.ITEMS.register(name, () -> (Item)item.apply(result.get()));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, ItemGroup group, Supplier<T> block) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItem(name, group, result);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithISTER(String name, ItemGroup group, Supplier<T> block, Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItemWithISTER(name, group, result, ister);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithISTER(String name, ItemGroup group, Supplier<T> block, Supplier<Callable<ItemStackTileEntityRenderer>> ister, Item.Properties itemProperties) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItemWithISTER(name, group, result, ister, itemProperties);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockPixelmon(String name, ItemGroup group, Supplier<T> block) {
        RegistryObject result = BLOCKS.register(name, block);
        BlockRegistration.registerBlockItemPixelmon(name, group, result);
        return result;
    }

    private static <T extends Block> RegistryObject<T> registerBlockNoItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> void registerBlockItem(String name, ItemGroup group, RegistryObject<T> block) {
        ItemRegistration.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
    }

    private static <T extends Block> void registerBlockItemWithISTER(String name, ItemGroup group, RegistryObject<T> block, Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
        ItemRegistration.ITEMS.register(name, () -> new PixelmonBlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(ister)));
    }

    private static <T extends Block> void registerBlockItemPixelmon(String name, ItemGroup group, RegistryObject<T> block) {
        ItemRegistration.ITEMS.register(name, () -> new PixelmonBlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
    }

    private static <T extends Block> void registerBlockItemWithISTER(String name, ItemGroup group, RegistryObject<T> block, Supplier<Callable<ItemStackTileEntityRenderer>> ister, Item.Properties itemProperties) {
        ItemRegistration.ITEMS.register(name, () -> new PixelmonBlockItem((Block)block.get(), itemProperties.func_200916_a(group).setISTER(ister)));
    }

    @SubscribeEvent
    public static void setRenderLayers(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ESSENCE_JAR.get()), (RenderType)RenderType.func_228645_f_());
    }
}

