/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class SuperEnergyRemoval
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        PlayerClientMyState me = client.getMe();
        boolean hasEnergy = me.getActiveCard().getAttachments().stream().anyMatch(CommonCardState::isEnergyEquivalence);
        if (!hasEnergy) {
            for (PokemonCardState card : me.getBenchCards()) {
                if (card == null || !card.getAttachments().stream().anyMatch(CommonCardState::isEnergyEquivalence)) continue;
                hasEnergy = true;
                break;
            }
        }
        if (!hasEnergy) {
            return false;
        }
        PlayerClientOpponentState opp = client.getOpponent();
        PokemonCardState card = opp.getActiveCard();
        if (card != null && card.getAttachments().stream().anyMatch(CommonCardState::isEnergyEquivalence)) {
            return true;
        }
        for (PokemonCardState bench : opp.getBenchCards()) {
            if (bench == null || !bench.getAttachments().stream().anyMatch(CommonCardState::isEnergyEquivalence)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        if (trainer.getParameters().size() == 0) {
            PlayerServerState me = server.getPlayer(server.getCurrentTurn());
            return SelectorHelper.generateSelectorForPokemonWithEnergy(me, true, null);
        }
        if (trainer.getParameters().size() == 1) {
            CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Discard, false);
            PokemonCardState pokemon = (PokemonCardState)trainer.getParameters().get(0);
            pokemon.getAttachments().stream().filter(CommonCardState::isEnergyEquivalence).forEach(attachment -> selector.getCardList().add(new CardWithLocation((CommonCardState)attachment, true, BoardLocation.Attachment, 0)));
            return selector;
        }
        if (trainer.getParameters().size() == 2) {
            PlayerServerState opp = server.getPlayer(server.getNextTurn());
            return SelectorHelper.generateSelectorForPokemonWithEnergy(opp, false, null);
        }
        if (trainer.getParameters().size() == 3) {
            CardSelectorState selector = new CardSelectorState(1, 2, CardSelectorDisplay.Discard, false);
            PokemonCardState pokemon = (PokemonCardState)trainer.getParameters().get(2);
            pokemon.getAttachments().stream().filter(CommonCardState::isEnergyEquivalence).forEach(attachment -> selector.getCardList().add(new CardWithLocation((CommonCardState)attachment, false, BoardLocation.Attachment, 0)));
            return selector;
        }
        return null;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() >= 4;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PokemonCardState myPokemon = (PokemonCardState)trainer.getParameters().get(0);
        CommonCardState myEnergy = trainer.getParameters().get(1);
        PokemonCardState oppPokemon = (PokemonCardState)trainer.getParameters().get(2);
        CommonCardState oppEnergy1 = trainer.getParameters().get(3);
        CommonCardState oppEnergy2 = null;
        if (trainer.getParameters().size() > 4) {
            oppEnergy2 = trainer.getParameters().get(4);
        }
        myPokemon.getAttachments().remove(myEnergy);
        server.getPlayer(server.getCurrentTurn()).getDiscardPile().add(myEnergy.getData());
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        oppPokemon.getAttachments().remove(oppEnergy1);
        opp.getDiscardPile().add(oppEnergy1.getData());
        if (oppEnergy2 != null) {
            oppPokemon.getAttachments().remove(oppEnergy2);
            opp.getDiscardPile().add(oppEnergy2.getData());
        }
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

