/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.tcg.api.accessors.CardPowers;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardModifier;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.duel.RenderingTCG;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardStatus;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.duel.trainer.ClefairyDoll;
import com.pixelmonmod.tcg.duel.trainer.MysteriousFossil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class PokemonCardState
extends CommonCardState {
    private final List<CommonCardState> attachments = new ArrayList<CommonCardState>();
    private int previousPokemonId;
    private PokemonCardStatus status;
    private PokemonAttackStatus[] attacksStatus;
    private Energy weakness;
    private int weaknessValue;
    private CardModifier weaknessCardModifier;
    private Energy resistance;
    private int resistanceValue;
    private CardModifier resistanceCardModifier;
    private boolean canRetreat;
    private int retreatCost;
    private CardPower cardAbility;
    private CardPower hiddenCardAbility;
    private boolean abilitiesDisabled;
    protected int turn;

    public PokemonCardState(BaseTrainerEffect effect, TrainerCardState trainer, int turn) {
        super(trainer.getData());
        this.turn = turn;
        if (effect instanceof ClefairyDoll || effect instanceof MysteriousFossil) {
            this.previousPokemonId = trainer.getData().getPreviousEvolutionDexID();
            this.attacksStatus = new PokemonAttackStatus[0];
            this.status = new PokemonCardStatus();
            this.weakness = null;
            this.resistance = null;
            this.retreatCost = 0;
            this.canRetreat = false;
        }
    }

    public PokemonCardState(ImmutableCard card, int turn) {
        super(card);
        this.turn = turn;
        this.transform(card, null);
    }

    @Override
    public void transform(ImmutableCard card, PokemonCardStatus stats) {
        super.transform(card, this.status);
        this.previousPokemonId = card.getPreviousEvolutionDexID();
        this.status = stats != null ? stats : new PokemonCardStatus();
        this.attacksStatus = new PokemonAttackStatus[card.getAttacks().size()];
        for (int i = 0; i < this.attacksStatus.length; ++i) {
            this.attacksStatus[i] = new PokemonAttackStatus(card.getAttacks().get(i));
        }
        this.cardAbility = card.getAbility();
        this.weakness = card.getEnergyWeakness();
        this.weaknessCardModifier = card.getWeaknessModifier();
        this.weaknessValue = card.getWeaknessValue();
        this.resistance = card.getEnergyResistance();
        this.resistanceCardModifier = card.getResistanceModifier();
        this.resistanceValue = card.getResistanceValue();
        this.retreatCost = card.getRetreatCost();
        this.canRetreat = true;
    }

    public PokemonCardState(PacketBuffer buf) {
        super(buf);
        int i;
        int attachmentSize = buf.readInt();
        for (i = 0; i < attachmentSize; ++i) {
            this.attachments.add(new CommonCardState(buf));
        }
        this.previousPokemonId = buf.readInt();
        this.status = new PokemonCardStatus(buf);
        if (!this.data.isFaceDown()) {
            int resistanceIndex;
            int weaknessIndex;
            String hiddenAbilityID;
            this.attacksStatus = new PokemonAttackStatus[buf.readInt()];
            for (i = 0; i < this.attacksStatus.length; ++i) {
                this.attacksStatus[i] = new PokemonAttackStatus(buf);
            }
            String abilityID = buf.func_218666_n();
            if (!abilityID.equals("")) {
                this.cardAbility = CardPowers.get(abilityID);
            }
            if (!(hiddenAbilityID = buf.func_218666_n()).equals("")) {
                this.hiddenCardAbility = CardPowers.get(hiddenAbilityID);
            }
            if ((weaknessIndex = buf.readInt()) != -1) {
                this.weakness = Energy.values()[weaknessIndex];
                this.weaknessCardModifier = CardModifier.values()[buf.readInt()];
                this.weaknessValue = buf.readInt();
            }
            if ((resistanceIndex = buf.readInt()) != -1) {
                this.resistance = Energy.values()[resistanceIndex];
                this.resistanceCardModifier = CardModifier.values()[buf.readInt()];
                this.resistanceValue = buf.readInt();
            }
            this.retreatCost = buf.readInt();
        }
        this.abilitiesDisabled = buf.readBoolean();
        this.canRetreat = buf.readBoolean();
        this.turn = buf.readInt();
    }

    @Override
    protected void write(PacketBuffer buf, boolean faceUp, boolean writeParams) {
        super.write(buf, faceUp, writeParams);
        buf.writeInt(this.attachments.size());
        for (CommonCardState card : this.attachments) {
            if (card instanceof PokemonCardState) {
                ((PokemonCardState)card).writeAsCommonCardState(buf, faceUp, writeParams);
                continue;
            }
            card.write(buf, faceUp, writeParams);
        }
        buf.writeInt(this.previousPokemonId);
        this.status.write(buf);
        if (faceUp) {
            buf.writeInt(this.attacksStatus.length);
            for (PokemonAttackStatus attackStatus : this.attacksStatus) {
                attackStatus.write(buf);
            }
            buf.func_180714_a(this.cardAbility == null ? "" : this.cardAbility.getID());
            buf.func_180714_a(this.hiddenCardAbility == null ? "" : this.hiddenCardAbility.getID());
            if (this.weakness == null) {
                buf.writeInt(-1);
            } else {
                buf.writeInt(this.weakness.ordinal());
                buf.writeInt(this.weaknessCardModifier.ordinal());
                buf.writeInt(this.weaknessValue);
            }
            if (this.resistance == null) {
                buf.writeInt(-1);
            } else {
                buf.writeInt(this.resistance.ordinal());
                buf.writeInt(this.resistanceCardModifier.ordinal());
                buf.writeInt(this.resistanceValue);
            }
            buf.writeInt(this.retreatCost);
        }
        buf.writeBoolean(this.abilitiesDisabled);
        buf.writeBoolean(this.canRetreat);
        buf.writeInt(this.turn);
    }

    @Override
    public void handleEndTurn(PokemonCardState attachTo, PlayerServerState player, GameServerState server) {
        super.handleEndTurn(attachTo, player, server);
        if (this.cardAbility != null && this.cardAbility.getEffect() != null) {
            this.cardAbility.getEffect().onEndTurn(this, server);
        }
        if (this.hiddenCardAbility != null && this.hiddenCardAbility.getEffect() != null) {
            this.hiddenCardAbility.getEffect().onEndTurn(this, server);
        }
        for (PokemonAttackStatus status : this.attacksStatus) {
            status.setMissed(false);
            if (server.getPlayer(server.getCurrentTurn()) != player) continue;
            status.setTemporaryEffect(null, null);
        }
    }

    void writeAsCommonCardState(PacketBuffer buf, boolean faceUp, boolean writeParams) {
        super.write(buf, faceUp, writeParams);
    }

    public void addDamage(PokemonCardState attacker, int damage, GameServerState server) {
        if (this.status.isDamageImmune()) {
            return;
        }
        if (attacker != null && this.cardAbility != null && this.cardAbility.getEffect() != null) {
            damage = this.cardAbility.getEffect().onDamage(this, attacker, server, damage);
        }
        if (attacker != null && this.hiddenCardAbility != null && this.hiddenCardAbility.getEffect() != null) {
            damage = this.hiddenCardAbility.getEffect().onDamage(this, attacker, server, damage);
        }
        this.status.setDamage(this.status.getDamage() + damage);
    }

    public void addCondition(PokemonCardState attacker, CardCondition cardCondition, Integer modifier, GameServerState server) {
        if (this.status.isConditionImmune()) {
            return;
        }
        if (attacker != null && this.cardAbility != null && this.cardAbility.getEffect() != null && !this.cardAbility.getEffect().onCondition(this, attacker, cardCondition, server)) {
            return;
        }
        if (attacker != null && this.hiddenCardAbility != null && this.hiddenCardAbility.getEffect() != null && !this.hiddenCardAbility.getEffect().onCondition(this, attacker, cardCondition, server)) {
            return;
        }
        this.status.addCondition(cardCondition, modifier);
    }

    public void addDamageFromCondition(int d) {
        this.status.setDamage(this.status.getDamage() + d);
    }

    public void bindPreviousPokemonSprite(Minecraft mc) {
        if (this.previousPokemonId > 0) {
            PixelmonSpecies.fromDex(this.previousPokemonId).ifPresent(species -> RenderingTCG.bind(PokemonFactory.create(species).getSprite()));
        }
    }

    public ResourceLocation getPreviousPokemonSprite() {
        Optional<Species> species;
        if (this.previousPokemonId > 0 && (species = PixelmonSpecies.fromDex(this.previousPokemonId)).isPresent()) {
            return PokemonFactory.create(species.get()).getSprite();
        }
        return null;
    }

    public List<CommonCardState> getAttachments() {
        return this.attachments;
    }

    public int getPreviousPokemonID() {
        return this.previousPokemonId;
    }

    public void setPreviousPokemonID(int previousPokemonId) {
        this.previousPokemonId = previousPokemonId;
    }

    public PokemonCardStatus getStatus() {
        return this.status;
    }

    public void setStatus(PokemonCardStatus s) {
        this.status = s;
    }

    public PokemonAttackStatus[] getAttacksStatus() {
        return this.attacksStatus;
    }

    @Override
    public CardPower getAbility() {
        return this.cardAbility;
    }

    public void setAbility(CardPower cardAbility) {
        this.cardAbility = cardAbility;
    }

    public boolean abilitiesDisabled() {
        return this.abilitiesDisabled;
    }

    public void disableAbilities(boolean disable) {
        this.abilitiesDisabled = disable;
    }

    public CardPower getHiddenAbility() {
        return this.hiddenCardAbility;
    }

    public void setHiddenAbility(CardPower hiddenCardAbility) {
        this.hiddenCardAbility = hiddenCardAbility;
    }

    public Energy getWeakness() {
        return this.weakness;
    }

    public void setWeakness(Energy weakness) {
        this.weakness = weakness;
    }

    public CardModifier getWeaknessModifier() {
        return this.weaknessCardModifier;
    }

    public void setWeaknessModifier(CardModifier weaknessCardModifier) {
        this.weaknessCardModifier = weaknessCardModifier;
    }

    public int getWeaknessValue() {
        return this.weaknessValue;
    }

    public void setWeaknessValue(int weaknessValue) {
        this.weaknessValue = weaknessValue;
    }

    public Energy getResistance() {
        return this.resistance;
    }

    public void setResistance(Energy resistance) {
        this.resistance = resistance;
    }

    public CardModifier getResistanceModifier() {
        return this.resistanceCardModifier;
    }

    public void setResistanceModifier(CardModifier resistanceCardModifier) {
        this.resistanceCardModifier = resistanceCardModifier;
    }

    public int getResistanceValue() {
        return this.resistanceValue;
    }

    public void setResistanceValue(int resistanceValue) {
        this.resistanceValue = resistanceValue;
    }

    public int getRetreatCost() {
        return this.retreatCost;
    }

    public void setRetreatCost(int retreatCost) {
        this.retreatCost = retreatCost;
    }

    public int getTurn() {
        return this.turn;
    }

    public void setCanRetreat(boolean canRetreat) {
        this.canRetreat = canRetreat;
    }

    public boolean canRetreat() {
        return this.canRetreat;
    }
}

