/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class PlayerCommonState {
    protected boolean isReady;
    protected TrainerCardState trainerCard = null;
    protected PokemonCardState activeCard = null;
    protected PokemonCardState[] benchCards = new PokemonCardState[5];
    protected List<ImmutableCard> graveyard = new ArrayList<ImmutableCard>();
    protected ImmutableCard[] prizeCards = null;
    private List<ImmutableCard> hand = new ArrayList<ImmutableCard>();
    protected boolean showPokemonsInClient = true;
    protected String cardBackID = CardBacks.STANDARD.getValueUnsafe().getName();
    protected String coinSetID = Coins.CHARMANDER.getValueUnsafe().getName();
    protected boolean isChoosingOppAttack = false;
    protected int pendingPrizeCount = 0;
    protected int pendingPrizePlayerIndex = 0;
    protected boolean isInGUI = true;
    protected boolean isSpectating;
    protected boolean trainersDisabled;
    protected String playerName;
    protected Integer timeLeft;
    protected Date counterEndTime;
    private boolean canSeeOpponentHand;
    private boolean isMe;
    private GameServerState server;
    private PlayerServerState player;

    public PlayerCommonState() {
    }

    public PlayerCommonState(PlayerServerState player, GameServerState server, boolean isMe) {
        this.isReady = player.isReady();
        this.trainerCard = player.getTrainerCard();
        this.activeCard = player.getActiveCard();
        this.benchCards = player.getBenchCards();
        this.graveyard = player.getDiscardPile();
        this.prizeCards = player.getPrizeCards();
        this.hand = player.getHand();
        this.cardBackID = player.getCardBackID();
        this.coinSetID = player.getCoinSetID();
        this.isChoosingOppAttack = player.isChoosingOppAttack;
        this.isInGUI = player.isInGUI;
        this.isSpectating = player.isSpectating;
        this.trainersDisabled = player.trainersDisabled;
        this.canSeeOpponentHand = false;
        this.playerName = player.getEntityPlayer().func_145748_c_().getString();
        if (player.getCounterEndTime() != null) {
            this.timeLeft = (int)(player.getCounterEndTime().getTime() - Calendar.getInstance().getTime().getTime());
        }
        this.server = server;
        this.player = player;
        this.isMe = isMe;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PlayerCommonState(PacketBuffer buf, GameServerState server, boolean isMe) {
        int locationOrdinal;
        if (buf.readBoolean()) {
            this.timeLeft = buf.readInt();
        }
        this.playerName = buf.func_218666_n();
        this.isSpectating = buf.readBoolean();
        this.isReady = buf.readBoolean();
        this.cardBackID = buf.func_218666_n();
        this.coinSetID = buf.func_218666_n();
        this.isChoosingOppAttack = buf.readBoolean();
        this.isInGUI = buf.readBoolean();
        this.pendingPrizePlayerIndex = buf.readInt();
        this.pendingPrizeCount = buf.readInt();
        this.hand = ByteBufTCG.readCardList(buf);
        this.graveyard = ByteBufTCG.readCardList(buf);
        this.trainersDisabled = buf.readBoolean();
        block6: while ((locationOrdinal = buf.readInt()) >= 0) {
            BoardLocation location = BoardLocation.values()[locationOrdinal];
            switch (location) {
                case Trainer: {
                    this.trainerCard = new TrainerCardState(ByteBufTCG.readCard(buf));
                    break;
                }
                case Active: {
                    this.activeCard = new PokemonCardState(buf);
                    break;
                }
                case Bench: {
                    int i;
                    this.benchCards = new PokemonCardState[5];
                    for (i = 0; i < this.benchCards.length; ++i) {
                        if (!buf.readBoolean()) continue;
                        this.benchCards[i] = new PokemonCardState(buf);
                    }
                    continue block6;
                }
                case Prize: {
                    int i;
                    this.prizeCards = new ImmutableCard[buf.readInt()];
                    for (i = 0; i < this.prizeCards.length; ++i) {
                        if (!buf.readBoolean()) continue;
                        this.prizeCards[i] = ImmutableCard.faceDown();
                    }
                    break;
                }
            }
        }
        if (this.timeLeft != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(14, this.timeLeft);
            this.counterEndTime = calendar.getTime();
        }
    }

    public void write(PacketBuffer buf) {
        buf.writeBoolean(this.timeLeft != null);
        if (this.timeLeft != null) {
            buf.writeInt(this.timeLeft.intValue());
        }
        buf.func_180714_a(this.playerName);
        buf.writeBoolean(this.isSpectating);
        buf.writeBoolean(this.isReady);
        buf.func_180714_a(this.cardBackID);
        buf.func_180714_a(this.coinSetID);
        buf.writeBoolean(this.isChoosingOppAttack);
        buf.writeBoolean(this.isInGUI);
        buf.writeInt(this.pendingPrizePlayerIndex);
        buf.writeInt(this.pendingPrizeCount);
        if (this.server.getOpponent((PlayerServerState)this.player).getEntityPlayer().field_71071_by.func_70431_c(new ItemStack((IItemProvider)TCGItems.eye))) {
            this.canSeeOpponentHand = true;
            ByteBufTCG.writeCardList(buf, this.hand);
        } else {
            for (PokemonCardState card : this.server.getOpponent(this.player).getActiveAndBenchCards()) {
                if (card == null || card.getAbility() == null || card.getAbility().getEffect() == null || !card.getAbility().getEffect().revealHand()) continue;
                this.canSeeOpponentHand = true;
                ByteBufTCG.writeCardList(buf, this.hand);
            }
        }
        if (!this.canSeeOpponentHand) {
            if (!this.isSpectating && this.isMe) {
                ByteBufTCG.writeCardList(buf, this.hand);
            } else {
                ByteBufTCG.writeFaceDownCardList(buf, this.hand);
            }
        }
        ByteBufTCG.writeCardList(buf, this.graveyard);
        buf.writeBoolean(this.trainersDisabled);
        if (this.prizeCards != null) {
            buf.writeInt(BoardLocation.Prize.ordinal());
            buf.writeInt(this.prizeCards.length);
            for (ImmutableCard prizeCard : this.prizeCards) {
                buf.writeBoolean(prizeCard != null);
            }
        }
        if (this.trainerCard != null) {
            buf.writeInt(BoardLocation.Trainer.ordinal());
            ByteBufTCG.writeCard(buf, this.trainerCard.getData());
        }
        if (this.activeCard != null) {
            buf.writeInt(BoardLocation.Active.ordinal());
            this.activeCard.write(buf, this.showPokemonsInClient);
        }
        buf.writeInt(BoardLocation.Bench.ordinal());
        for (PokemonCardState benchCard : this.benchCards) {
            buf.writeBoolean(benchCard != null);
            if (benchCard == null) continue;
            benchCard.write(buf, this.showPokemonsInClient);
        }
        buf.writeInt(-1);
    }

    public List<ImmutableCard> getHand() {
        return this.hand;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public TrainerCardState getTrainerCard() {
        return this.trainerCard;
    }

    public List<PokemonCardState> getActiveAndBenchCards() {
        ArrayList<PokemonCardState> cards = new ArrayList<PokemonCardState>();
        if (this.activeCard != null) {
            cards.add(this.activeCard);
        }
        for (PokemonCardState benchCard : this.benchCards) {
            if (benchCard == null) continue;
            cards.add(benchCard);
        }
        return cards;
    }

    public List<CardWithLocation> getActiveAndBenchCards(boolean isMine) {
        ArrayList<CardWithLocation> cards = new ArrayList<CardWithLocation>();
        if (this.activeCard != null) {
            cards.add(new CardWithLocation(this.activeCard, isMine, BoardLocation.Active, 0));
        }
        for (int i = 0; i < this.benchCards.length; ++i) {
            if (this.benchCards[i] == null) continue;
            cards.add(new CardWithLocation(this.benchCards[i], isMine, BoardLocation.Bench, i));
        }
        return cards;
    }

    public PokemonCardState getActiveCard() {
        return this.activeCard;
    }

    public PokemonCardState[] getBenchCards() {
        return this.benchCards;
    }

    public void setTrainerCard(TrainerCardState trainerCard) {
        this.trainerCard = trainerCard;
    }

    public void setActiveCard(PokemonCardState activeCard) {
        this.activeCard = activeCard;
    }

    public void setBenchCards(PokemonCardState[] benchCards) {
        this.benchCards = benchCards;
    }

    public List<ImmutableCard> getDiscardPile() {
        return this.graveyard;
    }

    public void setGraveyard(List<ImmutableCard> graveyard) {
        this.graveyard = graveyard;
    }

    public ImmutableCard[] getPrizeCards() {
        return this.prizeCards;
    }

    public void setPrizeCards(ImmutableCard[] prizeCards) {
        this.prizeCards = prizeCards;
    }

    public boolean hasPrizeLeft() {
        for (ImmutableCard card : this.prizeCards) {
            if (card == null) continue;
            return true;
        }
        return false;
    }

    public boolean isInBench(CommonCardState card) {
        for (PokemonCardState benchCard : this.benchCards) {
            if (benchCard != card) continue;
            return true;
        }
        return false;
    }

    public boolean isChoosingOppAttack() {
        return this.isChoosingOppAttack;
    }

    public void setChoosingOppAttack(boolean choosingOppAttack) {
        this.isChoosingOppAttack = choosingOppAttack;
    }

    public String getCardBackID() {
        return this.cardBackID;
    }

    public String getCoinSetID() {
        return this.coinSetID;
    }

    public Coin getCoin() {
        return Coins.get(this.getCoinSetID());
    }

    public boolean areTrainersDisabled() {
        return this.trainersDisabled;
    }

    public void setAreTrainersDisabled(boolean y) {
        this.trainersDisabled = y;
    }

    public PokemonCardState getCard(BoardLocation location, int locationSubindex) {
        switch (location) {
            case Active: {
                return this.activeCard;
            }
            case Bench: {
                return this.benchCards[locationSubindex];
            }
        }
        return null;
    }

    public int getPendingPrizePlayerIndex() {
        return this.pendingPrizePlayerIndex;
    }

    public int getPendingPrizeCount() {
        return this.pendingPrizeCount;
    }

    public boolean isInGUI() {
        return this.isInGUI;
    }

    public void setInGUI(boolean inGUI) {
        this.isInGUI = inGUI;
    }

    public Date getCounterEndTime() {
        return this.counterEndTime;
    }
}

