/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;

public class SearchDiscardEffect
extends BaseAttackEffect {
    private static final String CODE = "SEARCHDISCARD";
    private int searchCount;
    private CardType searchType;

    public SearchDiscardEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        CardSelectorState selector = new CardSelectorState(this.searchCount, this.searchCount, CardSelectorDisplay.Select, false);
        int pos = 0;
        for (ImmutableCard card : player.getDiscardPile()) {
            if (card == null || card.getCardType() != this.searchType) continue;
            selector.getCardList().add(new CardWithLocation(new CommonCardState(card), true, BoardLocation.DiscardPile, pos));
            ++pos;
        }
        if (selector.getCardList().size() == 0) {
            return null;
        }
        return selector;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        if (server.getPlayer(server.getCurrentTurn()).getDiscardPile().size() == 0) {
            return true;
        }
        if (this.getSelectorState(parameters, server) == null) {
            return true;
        }
        return parameters.size() == Math.min(this.searchCount, server.getPlayer(server.getCurrentTurn()).getDiscardPile().size());
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (parameters == null || parameters.size() < Math.min(this.searchCount, server.getPlayer(server.getCurrentTurn()).getDiscardPile().size())) {
            return;
        }
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        for (int j = 0; j < this.searchCount; ++j) {
            CommonCardState selected = (CommonCardState)parameters.get(j);
            player.getDiscardPile().remove(selected.getData());
            player.getHand().add(selected.getData());
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.searchCount = Integer.parseInt(args[1]);
        this.searchType = CardType.getCardTypeFromString(args[2]);
        return super.parse(args);
    }
}

