/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.client.gui.TCGResources;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.RenderingTCG;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class RenderCard {
    public static Minecraft mc = Minecraft.func_71410_x();

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardBase(MatrixStack matrix, double x, double y, double z, CommonCardState c, boolean isRotated, PlayerCommonState me, PlayerCommonState opp) {
        RenderCard.drawCardBase(matrix, (float)x, (float)y, (float)z, c, isRotated, me, opp);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardBase(MatrixStack matrix, float x, float y, float z, CommonCardState c, boolean isRotated, PlayerCommonState me, PlayerCommonState opp) {
        matrix.func_227860_a_();
        if (c != null) {
            if (c.getCardType().isCosmetic()) {
                RenderingTCG.bind(CardRenderingHelper.getCosmeticBackgroundTexture(c));
            }
            if (c.hasTransformation()) {
                RenderingTCG.bind(CardRenderingHelper.getBackgroundTexture(c.getTransformation().getCardType(), c.getTransformation().getMainEnergy(), c.getTransformation().isSpecial()));
            } else {
                RenderingTCG.bind(CardRenderingHelper.getBackgroundTexture(c.getData().getCardType(), c.getMainEnergy(), c.getData().isSpecial()));
            }
        } else if (me != null) {
            CardBack cardBack = CardBacks.get(me.getCardBackID());
            if (cardBack == null) {
                cardBack = CardBacks.STANDARD.getValueUnsafe();
            }
            RenderingTCG.bind(cardBack.getFile());
        } else {
            RenderingTCG.bind(CardBacks.STANDARD.getValueUnsafe().getFile());
        }
        if (isRotated) {
            RenderCard.handleRotation(matrix, x, y, z, 90, 1.0f);
        }
        RenderingTCG.draw(7, DefaultVertexFormats.field_227851_o_, matrix, buffer -> {
            buffer.vertex(x, y, z, 1.0f, 1.0f);
            buffer.vertex(x + 2.0f, y, z, 1.0f, 0.0f);
            buffer.vertex(x + 2.0f, y, z - 1.5f, 0.0f, 0.0f);
            buffer.vertex(x, y, z - 1.5f, 0.0f, 1.0f);
        });
        matrix.func_227865_b_();
    }

    public static void handleRotation(MatrixStack matrix, double x, double y, double z, int rotation, float scale) {
        RenderCard.handleRotation(matrix, (float)x, (float)y, (float)z, rotation, scale);
    }

    public static void handleRotation(MatrixStack matrix, float x, float y, float z, int rotation, float scale) {
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        if (rotation == 90) {
            matrix.func_227861_a_((double)x + 1.5, (double)y, (double)z);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
            matrix.func_227862_a_(scale, 1.0f, scale);
            matrix.func_227861_a_((double)(-x), (double)(-y), (double)(-z));
        } else if (rotation == 270) {
            matrix.func_227861_a_((double)x + 1.5, (double)y, (double)z);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(270.0f, 0.0f, 1.0f, 0.0f));
            matrix.func_227862_a_(scale, 1.0f, scale);
            matrix.func_227861_a_((double)(-x), (double)(-y), (double)(-z));
        } else if (rotation != 180) {
            matrix.func_227861_a_((double)(x + 1.0f), (double)y, (double)z - 0.75);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
            matrix.func_227861_a_((double)(-x - 1.0f), (double)(-y), (double)(-z) + 0.75);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCard(MatrixStack matrix, float x, float y, float z, CommonCardState card, int rotation, FontRenderer f, float t, PlayerCommonState me, PlayerCommonState opp) {
        matrix.func_227860_a_();
        if (card != null) {
            RenderCard.handleRotation(matrix, x, y, z, rotation, 1.0f);
            RenderCard.drawCardBase(matrix, x, y, z, card, false, me, opp);
            RenderCard.drawName(matrix, x, y, z, card);
            RenderCard.drawStage(matrix, x, y, z, card);
            RenderCard.drawType(matrix, x, y, z, card);
            if (card instanceof PokemonCardState) {
                RenderCard.drawEffects(matrix, x, y, z, (PokemonCardState)card);
            } else if (StringUtils.isNotBlank((CharSequence)card.getDescription())) {
                String cardText = card.getDescription();
                double dx = 1.02;
                double dz = -1.39;
                RenderCard.drawUnlocalizedString(matrix, (double)x + dx, (double)(y - 2.0f) + 1.0E-4, (double)z + dz, cardText, 0x202020, true, 90, 1.0f, true, 0, "");
            }
            RenderCard.drawHP(matrix, x, y, z, card);
            RenderCard.drawSprite(matrix, x, y, z, card);
            if (card instanceof PokemonCardState) {
                PokemonCardState pokemon = (PokemonCardState)card;
                RenderCard.drawWeakness(matrix, x, y, z, pokemon, f);
                RenderCard.drawResistance(matrix, x, y, z, pokemon, f);
            }
            RenderCard.drawSet(matrix, x, y, z, 0.5f, card);
            RenderCard.drawRarity(matrix, x, y, z, card);
            if (card instanceof PokemonCardState) {
                RenderCard.drawPrevEvolution(matrix, x, y, z, (PokemonCardState)card, f);
                RenderCard.drawRetreat(matrix, x, y, z, (PokemonCardState)card, me, opp);
            }
        }
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawSet(MatrixStack matrix, float x, float y, float z, float alpha, CommonCardState card) {
        float ya = y + 0.001f;
        if (card.getCardType() != CardType.ENERGY) {
            if (card.hasTransformation()) {
                if (card.getTransformation().getSetID() == 1) {
                    return;
                }
                RenderingTCG.bind(new ResourceLocation("tcg:gui/cards/icons/sets/" + card.getTransformation().getSetID() + ".png"));
            } else {
                if (card.getSetID() == 1) {
                    return;
                }
                RenderingTCG.bind(new ResourceLocation("tcg:gui/cards/icons/sets/" + card.getSetID() + ".png"));
            }
            float size = 0.25f;
            float xa = x + 1.055f;
            float za = z - 1.125f;
            RenderingTCG.draw(7, DefaultVertexFormats.field_227851_o_, matrix, buffer -> {
                buffer.vertex(xa, ya, za, alpha, 1.0f, 1.0f);
                buffer.vertex(xa + size, ya, za, alpha, 1.0f, 0.0f);
                buffer.vertex(xa + size, ya, za - size, alpha, 0.0f, 0.0f);
                buffer.vertex(xa, ya, za - size, alpha, 0.0f, 1.0f);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardOrBase(MatrixStack matrix, float x, float y, float z, CommonCardState card, int rotation, FontRenderer f, float t, PlayerClientOpponentState me, PlayerClientOpponentState opp) {
        matrix.func_227860_a_();
        if (!card.getData().isFaceDown()) {
            RenderCard.drawCard(matrix, x, y, z, card, rotation, f, t, me, opp);
        } else {
            RenderCard.drawCardBase(matrix, x, y, z, null, false, (PlayerCommonState)me, (PlayerCommonState)opp);
        }
        matrix.func_227865_b_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void drawSprite(MatrixStack matrix, float x, float y, float z, CommonCardState card) {
        float ya = y + 0.001f;
        if (card.getCardType() == CardType.ENERGY) return;
        if (card.hasTransformation()) {
            if (card.getTransformation().getHasCustomTex()) {
                RenderingTCG.bind(card.getTransformation().getCustomTexture());
                x -= 0.055f;
            } else {
                if (card.getTransformation().getPokemonID() == 0) return;
                card.bindPokemonSprite(mc);
            }
        } else if (card.getData().getHasCustomTex()) {
            RenderingTCG.bind(card.getData().getCustomTexture());
            x -= 0.055f;
        } else {
            if (card.getPokemonID() == 0) return;
            card.bindPokemonSprite(mc);
        }
        float size = 0.6f;
        float xa = x + 1.11f;
        float za = z - 0.45f;
        RenderingTCG.draw(7, DefaultVertexFormats.field_227851_o_, matrix, buffer -> {
            buffer.vertex(xa, ya, za, 1.0f, 1.0f);
            buffer.vertex(xa + size, ya, za, 1.0f, 0.0f);
            buffer.vertex(xa + size, ya, za - size, 0.0f, 0.0f);
            buffer.vertex(xa, ya, za - size, 0.0f, 1.0f);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawEnergySprite(MatrixStack matrix, double x, double y, double z, int rotation, Energy energy) {
        RenderCard.drawEnergySprite(matrix, (float)x, (float)y, (float)z, rotation, energy);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawEnergySprite(MatrixStack matrix, float x, float y, float z, int rotation, Energy energy) {
        RenderCard.drawSprite(matrix, x, y, z, 1.0, rotation, energy.getHighResTexture());
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawSprite(MatrixStack matrix, double x, double y, double z, double scale, int rotation, ResourceLocation resource) {
        RenderCard.drawSprite(matrix, (float)x, (float)y, (float)z, scale, rotation, resource);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawSprite(MatrixStack matrix, float x, float y, float z, double scale, int rotation, ResourceLocation resource) {
        float size = (float)(0.25 * scale);
        float xa = x + 1.11f;
        float ya = y + 0.001f;
        float za = z - 0.45f;
        RenderingTCG.draw(resource, 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
            buffer.vertex(xa, ya, za, 1.0f, 1.0f);
            buffer.vertex(xa + size, ya, za, 1.0f, 0.0f);
            buffer.vertex(xa + size, ya, za - size, 0.0f, 0.0f);
            buffer.vertex(xa, ya, za - size, 0.0f, 1.0f);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawPrevEvolution(MatrixStack matrix, float x, float y, float z, PokemonCardState card, FontRenderer f) {
        if (card.getPreviousPokemonID() > 0) {
            if (card.getPreviousPokemonID() == 10000) {
                RenderingTCG.bind(TCGResources.FOSSIL);
            } else {
                card.bindPreviousPokemonSprite(mc);
            }
            float size = 0.25f;
            float xa = x + 1.59f;
            float ya = y + 0.001f;
            float za = z - 0.065f;
            RenderingTCG.draw(7, DefaultVertexFormats.field_227851_o_, matrix, buffer -> {
                buffer.vertex(xa, ya, za, 1.0f, 1.0f);
                buffer.vertex(xa + size, ya, za, 1.0f, 0.0f);
                buffer.vertex(xa + size, ya, za - size, 0.0f, 0.0f);
                buffer.vertex(xa, ya, za - size, 0.0f, 1.0f);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawHP(MatrixStack matrix, float x, float y, float z, CommonCardState card) {
        CardType ct = card.getCardType();
        if (ct.isPokemon()) {
            int cardHealth = card.getHP();
            double dy = -1.695f;
            double dx = 1.92;
            double dz = -1.42;
            RenderCard.drawUnlocalizedString(matrix, (double)x + dx, (double)y + dy, (double)z + dz, (IFormattableTextComponent)new StringTextComponent(cardHealth + "HP"), 0x202020, false, 90, 1.0f, "");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawName(MatrixStack matrix, float x, float y, float z, CommonCardState card) {
        matrix.func_227860_a_();
        float dx = 1.7835f;
        float dy = -1.695f;
        float dz = -0.995f;
        float nameSize = Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)new TranslationTextComponent(card.getName().toLowerCase()));
        float widthConstant = 98.0f;
        if (card.getCardType() == CardType.STAGE1 || card.getCardType() == CardType.STAGE2 || card.getCardType() == CardType.EX || card.getCardType() == CardType.LVLX || card.getCardType() == CardType.GX) {
            widthConstant -= 25.5f;
        }
        if (nameSize > widthConstant) {
            float scaleFactor = 1.0f - (nameSize - widthConstant) / widthConstant;
            matrix.func_227861_a_(0.0, 0.0, (double)(z + dz));
            matrix.func_227862_a_(1.0f, 1.0f, scaleFactor);
            matrix.func_227861_a_(0.0, 0.0, (double)(-(z + dz)));
        }
        RenderCard.drawUnlocalizedString(matrix, (double)(x + dx), (double)(y + dy), (double)(z + dz), card.getName(), 0x202020, true, 90, 1.0f, "");
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawEffects(MatrixStack matrix, float x, float y, float z, PokemonCardState card) {
        float ya = y + 0.001f;
        float offset = 0.11f;
        if (card.getCardType() == CardType.STADIUM || card.getCardType() == CardType.TRAINER || card.getDescription() != null) {
            String cardText = card.getDescription();
            double dx = 1.12;
            double dz = -1.39;
            if (card.getCardType() == CardType.ENERGY) {
                RenderCard.drawUnlocalizedString(matrix, (double)x + dx - (double)(1.0f * offset), (double)(y - 2.0f), (double)z + dz, cardText, 0xDDDDDD, true, 90, 1.0f, true, 3, "");
            } else {
                RenderCard.drawUnlocalizedString(matrix, (double)x + dx - (double)(1.0f * offset), (double)(y - 2.0f), (double)z + dz, cardText, 0x202020, true, 90, 1.0f, true, 8, "");
            }
        } else {
            ResourceLocation texture;
            int line = 0;
            float dx = 1.02f;
            float dz = -1.39f;
            float size = 0.08f;
            CardPower cardAbility = card.getAbility();
            if (cardAbility != null && (texture = CardRenderingHelper.getAbilityTexture(cardAbility)) != null) {
                float o = -0.1f;
                RenderingTCG.draw(texture, 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                    buffer.vertex(x + dx + o, ya, z + dz + size, 1.0f, 1.0f);
                    buffer.vertex(x + dx + size + o, ya, z + dz + size, 1.0f, 0.0f);
                    buffer.vertex(x + dx + size + o, ya, z + dz, 0.0f, 0.0f);
                    buffer.vertex(x + dx + o, ya, z + dz, 0.0f, 1.0f);
                });
                matrix.func_227860_a_();
                IFormattableTextComponent name = new TranslationTextComponent(cardAbility.getName().toLowerCase()).func_240699_a_(TextFormatting.BOLD);
                float nameSize = Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)name);
                float widthConstant = 120.0f;
                if (nameSize > widthConstant) {
                    float scaleFactor = 1.0f - (nameSize - widthConstant) / widthConstant;
                    matrix.func_227861_a_(0.0, 0.0, (double)(z + dz) + ((double)size + 0.01) + 0.01);
                    matrix.func_227862_a_(1.0f, 1.0f, scaleFactor);
                    matrix.func_227861_a_(0.0, 0.0, -((double)(z + dz) + ((double)size + 0.01) + 0.01));
                }
                RenderCard.drawUnlocalizedString(matrix, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)(z + dz) + ((double)size + 0.01) + 0.01, cardAbility.getName(), 0x202020, true, 90, 1.0f, "\u00a7l");
                ++line;
                matrix.func_227865_b_();
                if (cardAbility.getDescription() != null) {
                    int linesForAbility;
                    int n = linesForAbility = card.getAttacksStatus() != null && card.getAttacksStatus().length > 0 ? 2 : 5;
                    if (card.getAttacksStatus().length == 1 && !card.getAttacksStatus()[0].hasDescription()) {
                        linesForAbility = 4;
                    }
                    RenderCard.drawUnlocalizedString(matrix, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)(z + dz), cardAbility.getDescription(), 0x444444, true, 90, 1.0f, true, linesForAbility, "\u00a7o");
                    line += linesForAbility;
                }
            }
            int[] descriptionLines = CardRenderingHelper.calculateAttackDescriptionLines(card.getAttacksStatus(), cardAbility != null, 94);
            for (int attackIndex = 0; attackIndex < card.getAttacksStatus().length; ++attackIndex) {
                PokemonAttackStatus attack = card.getAttacksStatus()[attackIndex];
                CardAttack cardAttackData = attack.getData();
                if (cardAttackData != null) {
                    for (int i = 0; i < cardAttackData.getCosts().size(); ++i) {
                        double moveDist = ((double)size + 0.01) * (double)i;
                        double o = -0.1;
                        int finalLine = line;
                        RenderingTCG.draw(cardAttackData.getCosts().get(i).getTexture(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                            double x1 = (double)(x + dx - (float)finalLine * offset) + o;
                            double x2 = (double)(x + dx + size - (float)finalLine * offset) + o;
                            buffer.vertex(x1, (double)y, (double)(z + dz) + moveDist + (double)size, 1.0f, 1.0f);
                            buffer.vertex(x2, (double)y, (double)(z + dz) + moveDist + (double)size, 1.0f, 0.0f);
                            buffer.vertex(x2, (double)y, (double)(z + dz) + moveDist, 0.0f, 0.0f);
                            buffer.vertex(x1, (double)y, (double)(z + dz) + moveDist, 0.0f, 1.0f);
                        });
                    }
                    String modifier = cardAttackData.getModifier() == null ? "" : cardAttackData.getModifier().toString();
                    int damage = cardAttackData.getDamage();
                    double rightZ = -0.25;
                    if (damage != 0) {
                        String damageString = damage + modifier;
                        if (attack.getDamageBonus() != 0) {
                            damageString = damageString + " +" + attack.getDamageBonus();
                        }
                        RenderCard.drawUnlocalizedString(matrix, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)z + rightZ, damageString, 0x202020, true, 90, 1.0f, "");
                    }
                    double offsetE = Math.max(((double)size + 0.01) * 3.0, ((double)size + 0.01) * (double)cardAttackData.getCosts().size());
                    matrix.func_227860_a_();
                    String name = new TranslationTextComponent(cardAttackData.getName().toLowerCase()).getString();
                    float nameSize = RenderCard.mc.field_71466_p.func_78256_a(name);
                    float widthConstant = 68.0f;
                    float offsetT = Math.max(3, cardAttackData.getCosts().size()) * 6 + 1;
                    nameSize -= offsetT;
                    if (nameSize > widthConstant) {
                        float scaleFactor = 1.0f - (nameSize - widthConstant) / widthConstant;
                        matrix.func_227861_a_(0.0, 0.0, (double)(z + dz) + 0.01 + offsetE);
                        matrix.func_227862_a_(1.0f, 1.0f, scaleFactor);
                        matrix.func_227861_a_(0.0, 0.0, -((double)(z + dz) + 0.01 + offsetE));
                    }
                    RenderCard.drawUnlocalizedString(matrix, (double)(x + dx - (float)line * offset), (double)(y - 2.0f), (double)(z + dz) + 0.01 + offsetE, cardAttackData.getName(), 0x202020, true, 90, 1.0f, "");
                    matrix.func_227865_b_();
                    if (cardAttackData.getText() != null) {
                        RenderCard.drawUnlocalizedString(matrix, (double)(x + dx - (float)(line + 1) * offset), (double)(y - 2.0f), (double)(z + dz), cardAttackData.getText(), 0x444444, true, 90, 1.0f, true, descriptionLines[attackIndex], "\u00a7o");
                    }
                }
                line += descriptionLines[attackIndex] + 1;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawRarity(MatrixStack matrix, float x, float y, float z, CommonCardState card) {
        CardRarity cardRarity;
        float ya = y + 0.001f;
        if (card.getCardType() != CardType.ENERGY && (cardRarity = card.getRarity()) != null) {
            RenderingTCG.bind(new ResourceLocation("tcg:gui/cards/icons/" + cardRarity.getUnlocalizedName() + ".png"));
            float hx = 0.1f;
            float wx = 0.1f;
            float xa = x + 1.02f;
            float za = z - 0.05f;
            RenderingTCG.draw(7, DefaultVertexFormats.field_227851_o_, matrix, buffer -> {
                buffer.vertex(xa, ya, za, 1.0f, 1.0f);
                buffer.vertex(xa + hx, ya, za, 1.0f, 0.0f);
                buffer.vertex(xa + hx, ya, za - wx, 0.0f, 0.0f);
                buffer.vertex(xa, ya, za - wx, 0.0f, 1.0f);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawRetreat(MatrixStack matrix, float x, float y, float z, PokemonCardState card, PlayerCommonState me, PlayerCommonState opp) {
        float ya = y + 0.001f;
        if (card.getCardType().isPokemon() && card.getRetreatCost() > 0) {
            int costModifier = LogicHelper.getCostModifier(me, opp);
            costModifier = Math.max(costModifier, -card.getRetreatCost());
            int renderCost = card.getRetreatCost() + costModifier;
            RenderingTCG.bind(TCGResources.ENERGY_COLORLESS);
            float size = 0.08f;
            float dx = 0.11f;
            float dz = -0.24f;
            float modo = size / 2.0f * (float)renderCost;
            for (int i = 0; i < renderCost; ++i) {
                float moveDist = size * (float)i - modo;
                RenderingTCG.draw(7, DefaultVertexFormats.field_227851_o_, matrix, buffer -> {
                    buffer.vertex(x + dx, ya, z + dz + moveDist, 1.0f, 1.0f);
                    buffer.vertex(x + dx + size, ya, z + dz + moveDist, 1.0f, 0.0f);
                    buffer.vertex(x + dx + size, ya, z + dz + moveDist - size, 0.0f, 0.0f);
                    buffer.vertex(x + dx, ya, z + dz + moveDist - size, 0.0f, 1.0f);
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawWeakness(MatrixStack matrix, float x, float y, float z, PokemonCardState card, FontRenderer f) {
        float ya = y + 0.001f;
        Energy energy = card.getWeakness();
        if (energy != null) {
            float size = 0.08f;
            float dx = 0.11f;
            float dz = -1.24f;
            String modifierString = card.getWeaknessModifier().toString() + card.getWeaknessValue();
            RenderingTCG.draw(energy.getTexture(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                buffer.vertex(x + dx, ya, z + dz, 1.0f, 1.0f);
                buffer.vertex(x + dx + size, ya, z + dz, 1.0f, 0.0f);
                buffer.vertex(x + dx + size, ya, z + dz - size, 0.0f, 0.0f);
                buffer.vertex(x + dx, ya, z + dz - size, 0.0f, 1.0f);
            });
            RenderCard.drawUnlocalizedString(matrix, (double)(x + dx) + 0.1, (double)-1.599f, (double)(z + dz) + 0.01, modifierString, 0xDDDDDD, true, 90, 1.0f, "");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawResistance(MatrixStack matrix, float x, float y, float z, PokemonCardState card, FontRenderer f) {
        float ya = y + 0.001f;
        Energy energy = card.getResistance();
        if (energy != null) {
            float size = 0.08f;
            float dx = 0.11f;
            float dz = -0.83f;
            String modifierString = card.getResistanceModifier().toString() + card.getResistanceValue();
            RenderingTCG.draw(energy.getTexture(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                buffer.vertex(x + dx, ya, z + dz, 1.0f, 1.0f);
                buffer.vertex(x + dx + size, ya, z + dz, 1.0f, 0.0f);
                buffer.vertex(x + dx + size, ya, z + dz - size, 0.0f, 0.0f);
                buffer.vertex(x + dx, ya, z + dz - size, 0.0f, 1.0f);
            });
            RenderCard.drawUnlocalizedString(matrix, (double)(x + dx) + 0.1, (double)-1.599f, (double)(z + dz) + 0.01, modifierString, 0xDDDDDD, true, 90, 1.0f, "");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawStage(MatrixStack matrix, float x, float y, float z, CommonCardState card) {
        CardType ct = card.getCardType();
        y += 0.001f;
        if (ct != CardType.ENERGY) {
            float hd = 0.14f;
            float wd = 0.38f;
            float xa = x + 1.66f;
            float za = z - 1.04f;
            float ya = y + 0.001f;
            RenderingTCG.draw(ct.getIcon(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                buffer.vertex(xa, ya, za, 1.0f, 1.0f);
                buffer.vertex(xa + hd, ya, za, 1.0f, 0.0f);
                buffer.vertex(xa + hd, ya, za - wd, 0.0f, 0.0f);
                buffer.vertex(xa, ya, za - wd, 0.0f, 1.0f);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawType(MatrixStack matrix, float x, float y, float z, CommonCardState c) {
        CardType ct = c.getCardType();
        float ya = y + 0.001f;
        if (ct == CardType.ENERGY || ct.isPokemon() && c.getMainEnergy() != null) {
            float size = 0.12f;
            float xa = x + 1.82f;
            float za = z - 0.7f;
            if (c.getSecondaryEnergy() != null) {
                RenderingTCG.draw(c.getMainEnergy().getTexture(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                    buffer.vertex(xa, ya, za, 1.0f, 0.0f);
                    buffer.vertex((double)xa + 0.2, (double)ya, (double)za, 0.0f, 0.0f);
                    buffer.vertex((double)xa + 0.2, (double)ya, (double)za - 0.2, 0.0f, 1.0f);
                    buffer.vertex((double)xa, (double)ya, (double)za - 0.2, 1.0f, 1.0f);
                });
                RenderingTCG.draw(c.getSecondaryEnergy().getTexture(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                    buffer.vertex(xa, ya, za, 1.0f, 0.0f);
                    buffer.vertex((double)xa + 0.2, (double)ya, (double)za, 0.0f, 0.0f);
                    buffer.vertex((double)xa + 0.2, (double)ya, (double)za - 0.2, 0.0f, 1.0f);
                    buffer.vertex((double)xa, (double)ya, (double)za - 0.2, 1.0f, 1.0f);
                });
            } else {
                RenderingTCG.draw(c.getMainEnergy().getTexture(), 7, DefaultVertexFormats.field_227852_q_, matrix, buffer -> {
                    buffer.vertex(xa, ya, za, 1.0f, 1.0f);
                    buffer.vertex(xa + size, ya, za, 1.0f, 0.0f);
                    buffer.vertex(xa + size, ya, za - size, 0.0f, 0.0f);
                    buffer.vertex(xa, ya, za - size, 0.0f, 1.0f);
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawUnlocalizedString(MatrixStack matrix, double x, double y, double z, String unlocalizedString, int color, boolean isUnicode, int rotation, float scale, String formatting) {
        RenderCard.drawUnlocalizedString(matrix, x, y, z, (IFormattableTextComponent)new TranslationTextComponent(unlocalizedString), color, isUnicode, rotation, scale, false, 0, formatting);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void drawUnlocalizedString(MatrixStack matrix, double x, double y, double z, IFormattableTextComponent unlocalizedString, int color, boolean isUnicode, int rotation, float scale, String formatting) {
        RenderCard.drawUnlocalizedString(matrix, x, y, z, unlocalizedString, color, isUnicode, rotation, scale, false, 0, formatting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawUnlocalizedString(MatrixStack matrix, double x, double y, double z, String unlocalizedString, int color, boolean isUnicode, int rotation, float scale, boolean isExtended, int maxLines, String formatting) {
        RenderCard.drawUnlocalizedString(matrix, x, y, z, (IFormattableTextComponent)new TranslationTextComponent(unlocalizedString), color, isUnicode, rotation, scale, isExtended, maxLines, formatting);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawUnlocalizedString(MatrixStack matrix, double x, double y, double z, IFormattableTextComponent unlocalizedString, int color, boolean isUnicode, int rotation, float scale, boolean isExtended, int maxLines, String formatting) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String string = unlocalizedString.getString();
        float var13 = 0.775f;
        float baseScale = 0.016666668f * var13 * scale;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)((float)x + 0.0f), (double)((float)y + 0.7f + 1.0f), (double)((float)z));
        if (rotation == 180) {
            matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            matrix.func_227863_a_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 0.0f, 1.0f));
        }
        if (rotation == 90) {
            matrix.func_227863_a_(QuaternionHelper.fromEuler(rotation, 1.0f, 0.0f, 0.0f));
            matrix.func_227863_a_(QuaternionHelper.fromEuler(-rotation, 0.0f, 0.0f, 1.0f));
        }
        matrix.func_227862_a_(-baseScale, -baseScale, baseScale);
        boolean force = Minecraft.func_71410_x().func_211821_e();
        if (isUnicode) {
            Minecraft.func_71410_x().func_238209_b_(true);
        }
        if (isExtended) {
            if (maxLines == 0) {
                fontRenderer.func_238421_b_(matrix, formatting + string, 0.0f, 0.0f, color);
            } else {
                List<String> lines = ScreenHelper.splitString(string, 94);
                int count = Math.min(lines.size(), maxLines);
                for (int i = 0; i < count; ++i) {
                    if (i == maxLines - 1) {
                        String lastLine = lines.get(i);
                        if (fontRenderer.func_78256_a(lastLine + "...") > 94 || lines.size() > maxLines) {
                            while (fontRenderer.func_78256_a(lastLine + "...") > 94) {
                                lastLine = lastLine.substring(0, lastLine.length() - 1);
                            }
                            if (lastLine.endsWith(",") || lastLine.endsWith(".") || lastLine.endsWith(":")) {
                                lastLine = lastLine.substring(0, lastLine.length() - 1);
                            }
                            lines.set(i, lastLine);
                        }
                    } else {
                        lines.set(i, lines.get(i));
                    }
                    lines.set(i, lines.get(i));
                    fontRenderer.func_238421_b_(matrix, formatting + lines.get(i), 0.0f, (float)(i * 8), color);
                }
            }
        } else {
            fontRenderer.func_238421_b_(matrix, formatting + string, 0.0f, 0.0f, color);
        }
        if (isUnicode) {
            Minecraft.func_71410_x().func_238209_b_(force);
        }
        matrix.func_227865_b_();
    }
}

