/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.duel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.client.gui.TargetScreen;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.client.helper.CardRenderingHelper;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.network.packets.battles.PrizeSelectorToServerPacket;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.Map;
import net.minecraft.client.resources.I18n;

public class PrizeSelectorScreen
extends TCGScreenBase {
    public static final int TEXTURE_WIDTH = 108;
    public static final int TEXTURE_HEIGHT = 167;
    private final BattleOwnedTileEntityController controller;
    private final TCGScreen parent;
    private ImmutableCard[] prizes;

    public PrizeSelectorScreen(TCGScreen parent, BattleOwnedTileEntityController controller) {
        this.parent = parent;
        this.controller = controller;
    }

    public ImmutableCard[] getPrizes() {
        return this.prizes;
    }

    public void setPrizes(ImmutableCard[] prizes) {
        this.prizes = prizes;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.prizes != null && !this.parent.isSpectating && mouseButton == 0) {
            if (this.controller.getClient().getMe().getPendingPrizeCount() > 0) {
                for (int index = 0; index < 6; ++index) {
                    int row = index / 3;
                    int col = index % 3 - 1;
                    TargetScreen target = this.getGuiTarget((int)((float)this.field_230708_k_ * this.parent.scaledFactor), (int)((float)this.field_230709_l_ * this.parent.scaledFactor), row, col);
                    if (!target.isInside(mouseX, mouseY)) continue;
                    NetworkHelper.sendToServer(new PrizeSelectorToServerPacket(this.controller.func_174877_v(), index));
                }
            } else {
                this.controller.getShowingPrizes().clear();
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (this.prizes != null) {
            Map<Integer, ImmutableCard> showing = this.controller.getShowingPrizes();
            int w = (int)((float)this.field_230708_k_ * this.parent.scaledFactor);
            int h = (int)((float)this.field_230709_l_ * this.parent.scaledFactor);
            for (int i = 0; i < 6; ++i) {
                int row = i / 3;
                int col = i % 3 - 1;
                TargetScreen target = this.getGuiTarget(w, h, row, col);
                target.draw(matrix, mouseX, mouseY);
                if (i >= this.prizes.length) continue;
                if (showing.containsKey(i)) {
                    float factor = 0.5f;
                    if (target.isInside(mouseX, mouseY)) {
                        factor = 1.0f;
                    }
                    factor = Math.min(1.2f, factor * (2.0f / this.parent.scaledFactor));
                    matrix.func_227860_a_();
                    matrix.func_227862_a_(factor, factor, 1.0f);
                    matrix.func_227861_a_((double)(((float)w / 2.0f - 54.0f + (float)(col * 118) + 54.0f) / factor / this.parent.scaledFactor), (double)(((float)h / 2.0f - 167.0f - 5.0f + (float)(row * 177) + 83.75f) / factor / this.parent.scaledFactor), 1.0);
                    CardRenderingHelper.drawCard(matrix, new CommonCardState(showing.get(i)), 0, 0, 0.0f, 1.0f, 0.0, this.controller.getClient().getMe(), this.controller.getClient().getOpponent());
                    matrix.func_227865_b_();
                    continue;
                }
                if (this.prizes[i] == null) continue;
                if (target.isInside(mouseX, mouseY)) {
                    ScreenHelper.drawImageQuad(CardBacks.get(this.controller.getClient().getMe().getCardBackID()).getFile(), matrix, ((float)w / 2.0f - 54.0f + (float)(col * 118) - 5.0f) / this.parent.scaledFactor, ((float)h / 2.0f - 167.0f - 5.0f + (float)(row * 177) - 5.0f) / this.parent.scaledFactor, 118.0f / this.parent.scaledFactor, 177.0f / this.parent.scaledFactor, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                    continue;
                }
                ScreenHelper.drawImageQuad(CardBacks.get(this.controller.getClient().getMe().getCardBackID()).getFile(), matrix, ((float)w / 2.0f - 54.0f + (float)(col * 118)) / this.parent.scaledFactor, ((float)h / 2.0f - 167.0f - 5.0f + (float)(row * 177)) / this.parent.scaledFactor, 108.0f / this.parent.scaledFactor, 167.0f / this.parent.scaledFactor, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            }
            String text = "";
            text = this.controller.getClient().getMe().getPendingPrizeCount() > 0 ? I18n.func_135052_a((String)"battle.selector.prize", (Object[])new Object[0]) : I18n.func_135052_a((String)"battle.selector.prize.close", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, text, (float)w / 2.0f / this.parent.scaledFactor - (float)ScreenHelper.getStringWidth(text) / 2.0f, ((float)h / 2.0f - 167.0f - 40.0f) / this.parent.scaledFactor, 0xFFFFFF, true);
        }
    }

    private TargetScreen getGuiTarget(int w, int h, int row, int col) {
        int minX = (int)(((float)w / 2.0f - 54.0f + (float)(col * 118) - 5.0f) / this.parent.scaledFactor);
        int minY = (int)(((float)h / 2.0f - 167.0f - 5.0f + (float)(row * 177) - 5.0f) / this.parent.scaledFactor);
        int tmpRight = (int)(118.0f / this.parent.scaledFactor);
        int tmpBottom = (int)(177.0f / this.parent.scaledFactor);
        return new TargetScreen(minX, minY, tmpRight, tmpBottom, 0.0f);
    }
}

