/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.client.gui.base;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.tcg.client.gui.base.TCGScreenBase;
import java.util.ArrayList;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TCGScreenChattableBase
extends TCGScreenBase {
    private int bPosX = 0;
    private int bPosY = 0;
    private int bWidth = 0;
    public static boolean chatOpen = false;
    private int sentHistoryCursor = -1;
    protected TextFieldWidget inputField;
    private boolean autoComplete;
    private int nameCycle;
    private ArrayList<String> onlineNames = Lists.newArrayList();
    private String savedText;

    public TCGScreenChattableBase() {
        this.field_230706_i_ = Minecraft.func_71410_x();
        chatOpen = false;
        this.inputField = new TextFieldWidget(this.field_230706_i_.field_71466_p, 0, 0, 0, 0, StringTextComponent.field_240750_d_);
        this.inputField.func_146203_f(100);
        this.inputField.func_146195_b(true);
        this.inputField.func_146180_a("");
        this.inputField.func_146205_d(false);
        this.inputField.func_146189_e(false);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.sentHistoryCursor = this.field_230706_i_.field_71456_v.func_146158_b().func_146238_c().size();
        this.handleResize(this.field_230706_i_);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.inputField != null) {
            this.inputField.func_146178_a();
        }
    }

    private void handleResize(Minecraft mc) {
        MainWindow window = this.field_230706_i_.func_228018_at_();
        float guiScaling = (float)((double)((float)window.func_198091_l() / 240.0f) / window.func_198100_s());
        this.bPosX = 42;
        this.bPosY = this.field_230709_l_ - (int)(56.0f * guiScaling);
        this.bWidth = this.field_230708_k_ - 124;
        this.inputField.field_230690_l_ = this.bPosX + 2;
        this.inputField.field_230691_m_ = this.bPosY + 2;
        this.inputField.func_230991_b_(this.bWidth - 2);
        this.inputField.setHeight(this.bPosY + 10);
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
        this.field_230706_i_.field_71456_v.func_146158_b().func_146240_d();
        chatOpen = false;
    }

    public void chatOpened(String start) {
        if (this.field_230706_i_.field_71474_y.field_74343_n == ChatVisibility.HIDDEN || this.inputField == null) {
            return;
        }
        if (start != null) {
            this.inputField.func_146180_a(start);
        } else {
            this.inputField.func_146180_a("");
        }
        chatOpen = true;
        this.inputField.func_146189_e(true);
    }

    public void chatClosed() {
        chatOpen = false;
        this.inputField.func_146189_e(false);
        this.inputField.func_146180_a("");
    }

    @Override
    public boolean func_231042_a_(char key, int keyCode) {
        if (!(keyCode != Minecraft.func_71410_x().field_71474_y.field_74310_D.getKey().func_197937_c() && keyCode != 47 || chatOpen)) {
            this.chatOpened(keyCode == 47 ? "/" : null);
            return true;
        }
        if (keyCode == 1 && chatOpen) {
            this.chatClosed();
            return true;
        }
        if (chatOpen) {
            if (keyCode == 258) {
                this.completePlayerName();
            } else {
                this.autoComplete = false;
            }
            if (keyCode != 28 && keyCode != 156) {
                if (keyCode == 200) {
                    this.getSentHistory(-1);
                } else if (keyCode == 208) {
                    this.getSentHistory(1);
                } else if (keyCode == 201) {
                    this.field_230706_i_.field_71456_v.func_146158_b().func_194813_a(1.0);
                } else if (keyCode == 209) {
                    this.field_230706_i_.field_71456_v.func_146158_b().func_194813_a(-1.0);
                } else {
                    this.inputField.func_231042_a_(key, keyCode);
                }
            } else {
                String s = this.inputField.func_146179_b().trim();
                if (!s.isEmpty()) {
                    this.field_230706_i_.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(s));
                    this.field_230706_i_.field_71439_g.func_71165_d(s);
                }
                this.inputField.func_146180_a("");
                this.chatClosed();
            }
        }
        return super.func_231042_a_(key, keyCode);
    }

    public void completePlayerName() {
        if (this.autoComplete) {
            this.inputField.func_146175_b(this.inputField.func_146187_c(-1) - this.inputField.func_146198_h());
            if (this.nameCycle >= this.onlineNames.size()) {
                this.nameCycle = 0;
            }
        } else {
            int i = this.inputField.func_146187_c(-1);
            this.onlineNames.clear();
            this.nameCycle = 0;
            String s1 = this.inputField.func_146179_b().substring(i).toLowerCase();
            String s = this.inputField.func_146179_b().substring(0, this.inputField.func_146198_h());
            if (this.onlineNames.isEmpty()) {
                return;
            }
            this.autoComplete = true;
            this.inputField.func_146175_b(i - this.inputField.func_146198_h());
        }
        if (this.onlineNames.size() > 1) {
            StringBuilder stringbuilder = new StringBuilder();
            for (String s : this.onlineNames) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(s);
            }
            this.field_230706_i_.field_71456_v.func_146158_b().func_238495_b_((ITextComponent)new StringTextComponent(stringbuilder.toString()));
        }
        this.inputField.func_146180_a(this.inputField.func_146179_b() + TextFormatting.func_110646_a((String)this.onlineNames.get(this.nameCycle++)));
    }

    public void getSentHistory(int par1) {
        int j = this.sentHistoryCursor + par1;
        int k = this.field_230706_i_.field_71456_v.func_146158_b().func_146238_c().size();
        if (j < 0) {
            j = 0;
        }
        if (j > k) {
            j = k;
        }
        if (j != this.sentHistoryCursor) {
            try {
                if (j == k) {
                    this.sentHistoryCursor = k;
                    this.inputField.func_146180_a(this.savedText);
                } else {
                    if (this.sentHistoryCursor == k) {
                        this.savedText = this.inputField.func_146179_b();
                    }
                    this.inputField.func_146180_a((String)this.field_230706_i_.field_71456_v.func_146158_b().func_146238_c().get(j));
                    this.sentHistoryCursor = j;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.inputField.func_231044_a_(mouseX, mouseY, mouseButton);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public int getChatWidth() {
        return TCGScreenChattableBase.calculateChatboxWidth(this.field_230706_i_.field_71474_y.field_96692_F);
    }

    public int getChatHeight() {
        return TCGScreenChattableBase.calculateChatboxHeight(this.field_230706_i_.field_71474_y.field_96694_H);
    }

    public double getChatScale() {
        return this.field_230706_i_.field_71474_y.field_96691_E;
    }

    public static int calculateChatboxWidth(double p_146233_0_) {
        int short1 = 320;
        int b0 = 40;
        return MathHelper.func_76128_c((double)(p_146233_0_ * (double)(short1 - b0) + (double)b0));
    }

    public static int calculateChatboxHeight(double p_146243_0_) {
        int short1 = 180;
        int b0 = 20;
        return MathHelper.func_76128_c((double)(p_146243_0_ * (double)(short1 - b0) + (double)b0));
    }

    public int getLineCount() {
        return this.getChatHeight() / 9;
    }
}

