/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.block;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.init.registry.BlockRegistration;
import com.pixelmonmod.tcg.listener.TCGServerEventListeners;
import com.pixelmonmod.tcg.tileentity.EssenceJarTileEntity;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EssenceJarBlock
extends ContainerBlock {
    public static final ModelResourceLocation MODEL = new ModelResourceLocation("tcg:essence_jar", "inventory");
    public static final BooleanProperty CONTENTS = BooleanProperty.func_177716_a((String)"contents");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public EssenceJarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_200944_c());
    }

    public static ItemStack createJarItem(DyeColor dyeColor) {
        Color color = new Color(dyeColor.getColorValue());
        return EssenceJarBlock.createJarItem(0.0, color, dyeColor.func_176762_d());
    }

    public static ItemStack createJarItem(double jarPercentFull, Color color, String colorName) {
        if (TCGBlocks.essence_jar == null) {
            return ItemStack.field_190927_a;
        }
        Item item = TCGBlocks.essence_jar.func_199767_j();
        ItemStack itemStack = new ItemStack((IItemProvider)item);
        itemStack.func_196082_o();
        itemStack.func_190925_c("BlockEntityTag").func_74780_a("EssenceJarPercent", jarPercentFull);
        int amountOfEssenceToFillJar = TCGConfigProxy.getConfig() == null ? 100 : TCGConfigProxy.getConfig().getEssenceToFillJar();
        itemStack.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarCount", (int)((double)amountOfEssenceToFillJar * jarPercentFull));
        itemStack.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarColorRed", color.getRed());
        itemStack.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarColorGreen", color.getGreen());
        itemStack.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarColorBlue", color.getBlue());
        itemStack.func_190925_c("BlockEntityTag").func_74778_a("EssenceJarColorName", ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent("color.minecraft." + colorName.toLowerCase(Locale.ROOT))));
        return itemStack;
    }

    public static ItemStack createFullJarItem(DyeColor dyeColor) {
        Color color = new Color(dyeColor.getColorValue());
        return EssenceJarBlock.createFullJarItem(color, dyeColor.func_176762_d());
    }

    public static ItemStack createFullJarItem(Color color, String colorName) {
        if (TCGBlocks.essence_jar == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = EssenceJarBlock.createJarItem(1.0, color, colorName);
        itemStack.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarCount", TCGConfigProxy.getConfig() == null ? 100 : TCGConfigProxy.getConfig().getEssenceToFillJar());
        itemStack.func_190925_c("BlockEntityTag").func_74780_a("EssenceJarPercent", 1.0);
        return itemStack;
    }

    public static int addEssence(ItemStack stack, int essence, ServerPlayerEntity player) {
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        int current = nbt.func_74762_e("EssenceJarCount") + essence;
        int target = TCGConfigProxy.getConfig().getEssenceToFillJar();
        int finalCurrent = Math.min(current, target);
        nbt.func_74780_a("EssenceJarPercent", Math.min(1.0, (double)finalCurrent / (double)target));
        nbt.func_74768_a("EssenceJarCount", finalCurrent);
        if (!nbt.func_74764_b("EssenceJarColorRed")) {
            DyeColor dyeColor = RandomHelper.getRandomElementFromArray(DyeColor.values());
            Color color = new Color(dyeColor.getColorValue());
            nbt.func_74768_a("EssenceJarColorRed", color.getRed());
            nbt.func_74768_a("EssenceJarColorGreen", color.getGreen());
            nbt.func_74768_a("EssenceJarColorBlue", color.getBlue());
            nbt.func_74778_a("EssenceJarColorName", ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent("color.minecraft." + dyeColor.func_176762_d())));
        }
        Color color = new Color(nbt.func_74762_e("EssenceJarColorRed"), nbt.func_74762_e("EssenceJarColorGreen"), nbt.func_74762_e("EssenceJarColorBlue"));
        TCGServerEventListeners.playEssenceJarEffect(finalCurrent, essence, current, target, player.func_71121_q(), player.func_233580_cy_().func_177982_a(0, 1, 0), color);
        return Math.max(0, current - target);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> lore, ITooltipFlag flag) {
        IFormattableTextComponent ftc;
        super.func_190948_a(stack, world, lore, flag);
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        if (nbt.func_74764_b("EssenceJarColorName") && (ftc = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("EssenceJarColorName"))) != null) {
            lore.add((ITextComponent)ftc.func_240699_a_(TextFormatting.GRAY));
        }
        lore.add((ITextComponent)new TranslationTextComponent("block.tcg.essence_jar.lore", new Object[]{(int)(nbt.func_74769_h("EssenceJarPercent") * 100.0)}).func_240699_a_(TextFormatting.GRAY));
    }

    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        TileEntity te;
        if (TCGConfigProxy.getConfig().shouldRandomTickGainEssence() && (te = p_225542_2_.func_175625_s(p_225542_3_)) instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).addEssence(1);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{CONTENTS});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)CONTENTS, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack itemStack = super.getPickBlock(state, target, world, pos, player);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).applyValuesToItem(itemStack);
        }
        return itemStack;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack itemStack = super.func_185473_a(world, pos, state);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).applyValuesToItem(itemStack);
        }
        return itemStack;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        ArrayList drops = Lists.newArrayList();
        ItemStack stack = new ItemStack((IItemProvider)BlockRegistration.ESSENCE_JAR.get());
        TileEntity te = (TileEntity)context.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof EssenceJarTileEntity) {
            ((EssenceJarTileEntity)te).applyValuesToItem(stack);
        }
        drops.add(stack);
        return drops;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te;
        if (placer instanceof ServerPlayerEntity && (te = worldIn.func_175625_s(pos)) instanceof EssenceJarTileEntity) {
            EssenceJarTileEntity jar = (EssenceJarTileEntity)te;
            if (!jar.setValuesFromItem(stack)) {
                jar.setColor(RandomHelper.getRandomElementFromArray(DyeColor.values()));
            }
            jar.func_70296_d();
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public VoxelShape func_230322_a_(BlockState p_230322_1_, IBlockReader p_230322_2_, BlockPos p_230322_3_, ISelectionContext p_230322_4_) {
        return VoxelShapes.func_197880_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EssenceJarTileEntity) {
            EssenceJarTileEntity jar = (EssenceJarTileEntity)te;
            return MathHelper.func_76125_a((int)((int)(jar.getFillPercentDirect() * 16.0)), (int)0, (int)15);
        }
        return 0;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new EssenceJarTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> items) {
        super.func_149666_a(tab, items);
        for (DyeColor color : DyeColor.values()) {
            items.add((Object)EssenceJarBlock.createFullJarItem(color));
            items.add((Object)EssenceJarBlock.createJarItem(color));
        }
    }
}

