/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.typeadapters;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.util.helpers.JsonHelper;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.api.accessors.PowerEffects;
import com.pixelmonmod.tcg.api.card.CardModifier;
import com.pixelmonmod.tcg.api.card.CardPowerType;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ability.CardPower;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.ResourceLocation;

public class ImmutableCardTypeAdapter
implements JsonDeserializer<ImmutableCard>,
JsonSerializer<ImmutableCard> {
    public ImmutableCard deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String code = object.getAsJsonPrimitive("code").getAsString();
        try {
            BasePowerEffect effect;
            int id = object.getAsJsonPrimitive("id").getAsInt();
            int setId = object.getAsJsonPrimitive("setId").getAsInt();
            CardType cardType = (CardType)((Object)context.deserialize(object.get("cardType"), CardType.class));
            boolean isSpecial = object.getAsJsonPrimitive("isSpecial").getAsBoolean();
            int hp = JsonHelper.getOrDefault(object, "hp", Integer.TYPE, 0, context);
            Energy energy1 = (Energy)((Object)context.deserialize(object.get("energy1"), Energy.class));
            Energy energy2 = (Energy)((Object)context.deserialize(object.get("energy2"), Energy.class));
            int pokemonId = JsonHelper.getOrDefault(object, "pokemonId", Integer.TYPE, -1, context);
            String name = object.getAsJsonPrimitive("name").getAsString();
            String description = object.getAsJsonPrimitive("description").getAsString();
            int previousPokemonId = JsonHelper.getOrDefault(object, "previousPokemonId", Integer.TYPE, -1, context);
            CardPower cardAbility = null;
            if (object.has("cardAbility") && !object.get("cardAbility").isJsonNull() && (effect = PowerEffects.get(object.get("cardAbility").getAsString())) != null) {
                cardAbility = new CardPower(effect.getCode(), effect.isPassive() ? CardPowerType.BODY : CardPowerType.POWER, effect);
            }
            AtomicInteger index = new AtomicInteger(1);
            ImmutableList<CardAttack> cardAttacks = JsonHelper.deserializeList(object.getAsJsonArray("cardAttacks"), e -> {
                CardAttack attack = (CardAttack)context.deserialize(e, CardAttack.class);
                attack.setID(code, index.getAndIncrement());
                return attack;
            });
            Energy energyResistance = (Energy)((Object)context.deserialize(object.get("energyResistance"), Energy.class));
            int resistanceValue = JsonHelper.getOrDefault(object, "resistanceValue", Integer.TYPE, 0, context);
            CardModifier resistanceCardModifier = (CardModifier)((Object)context.deserialize(object.get("resistanceCardModifier"), CardModifier.class));
            Energy energyWeakness = (Energy)((Object)context.deserialize(object.get("energyWeakness"), Energy.class));
            int weaknessValue = JsonHelper.getOrDefault(object, "weaknessValue", Integer.TYPE, 0, context);
            CardModifier weaknessCardModifier = (CardModifier)((Object)context.deserialize(object.get("weaknessCardModifier"), CardModifier.class));
            int retreatCost = JsonHelper.getOrDefault(object, "retreatCost", Integer.TYPE, 0, context);
            CardRarity cardRarity = (CardRarity)((Object)context.deserialize(object.get("cardRarity"), CardRarity.class));
            ResourceLocation customTexture = (ResourceLocation)context.deserialize(object.get("customTexture"), ResourceLocation.class);
            int customTextureX = JsonHelper.getOrDefault(object, "customTextureX", Integer.TYPE, 0, context);
            int customTextureY = JsonHelper.getOrDefault(object, "customTextureY", Integer.TYPE, 0, context);
            return new ImmutableCard(object.toString(), id, setId, cardType, isSpecial, hp, energy1, energy2, pokemonId, code, name, description, previousPokemonId, cardAbility, (List<CardAttack>)cardAttacks, energyResistance, resistanceValue, resistanceCardModifier, energyWeakness, weaknessValue, weaknessCardModifier, retreatCost, cardRarity, customTexture, customTextureX, customTextureY, null);
        }
        catch (Exception e2) {
            TCG.LOGGER.error("Failed to read card: " + code);
            return null;
        }
    }

    public JsonElement serialize(ImmutableCard src, Type typeOfSrc, JsonSerializationContext context) {
        return null;
    }
}

