/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.plant;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PlantXurkitreeFeature
extends Feature<NoFeatureConfig> {
    public PlantXurkitreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int i;
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.05f)) {
            return false;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos.func_177958_n(), generator.func_222532_b(pos.func_177958_n(), pos.func_177956_o(), Heightmap.Type.WORLD_SURFACE_WG), pos.func_177952_p());
        while (mutablePos.func_177956_o() > 20 && ((blockState = level.func_180495_p((BlockPos)mutablePos)).func_203425_a(Blocks.field_150350_a) || blockState.func_203425_a(Blocks.field_150355_j))) {
            mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
        }
        int radius = RandomHelper.getRandomNumberBetween(20, 40);
        int points = RandomHelper.getRandomNumberBetween(5, 7);
        int biggestY = -1;
        for (int i2 = 0; i2 < points; ++i2) {
            int startingX = (int)Math.round((double)pos.func_177958_n() + (double)radius * Math.cos(Math.PI * 2 * (double)i2 / (double)points));
            int startingZ = (int)Math.round((double)pos.func_177952_p() + (double)radius * Math.sin(Math.PI * 2 * (double)i2 / (double)points));
            int currentX = startingX;
            int currentZ = startingZ;
            int lastY = -1;
            while (currentX != pos.func_177958_n() || currentZ != pos.func_177952_p()) {
                int distance = (int)Math.sqrt(Math.pow(currentX - pos.func_177958_n(), 2.0) + Math.pow(currentZ - pos.func_177952_p(), 2.0));
                int y = (int)((double)radius - Math.sqrt((double)(2 * radius) * (double)distance));
                if (lastY != -1) {
                    for (int deltaY = lastY; deltaY < y; ++deltaY) {
                        BlockState blockState2 = Blocks.field_235406_np_.func_176223_P();
                        if (deltaY % 5 == 0) {
                            blockState2 = Blocks.field_180398_cJ.func_176223_P();
                        }
                        this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_181079_c(currentX, pos.func_177956_o() + deltaY, currentZ), blockState2);
                    }
                }
                lastY = y;
                if (y > biggestY) {
                    biggestY = y;
                }
                BlockState blockState3 = Blocks.field_235406_np_.func_176223_P();
                if (y % 5 == 0) {
                    blockState3 = Blocks.field_180398_cJ.func_176223_P();
                }
                this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_181079_c(currentX, pos.func_177956_o() + y, currentZ), blockState3);
                if (currentX < pos.func_177958_n()) {
                    ++currentX;
                } else if (currentX > pos.func_177958_n()) {
                    --currentX;
                }
                if (currentZ < pos.func_177952_p()) {
                    ++currentZ;
                    continue;
                }
                if (currentZ <= pos.func_177952_p()) continue;
                --currentZ;
            }
        }
        double[] xCoords = new double[10];
        double[] yCoords = new double[10];
        double starRadius = 4.0;
        double centerX = 0.0;
        double centerY = 0.0;
        int smallStarRadius = 2;
        for (double x = (double)(-smallStarRadius); x <= (double)smallStarRadius; x += 1.0) {
            for (double y = (double)(-smallStarRadius); y <= (double)smallStarRadius; y += 1.0) {
                for (double z = (double)(-smallStarRadius); z <= (double)smallStarRadius; z += 1.0) {
                    double distance = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
                    if (!(distance <= (double)smallStarRadius)) continue;
                    this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_189532_c((double)pos.func_177958_n() + x, (double)pos.func_177956_o() + ((double)biggestY + 0.5 * (double)smallStarRadius) + y, (double)pos.func_177952_p() + z), Blocks.field_180398_cJ.func_176223_P());
                }
            }
        }
        this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_189532_c((double)pos.func_177958_n(), (double)pos.func_177956_o() + ((double)biggestY + 0.5 * (double)smallStarRadius), (double)pos.func_177952_p()), random.nextBoolean() ? Blocks.field_235398_nh_.func_176223_P() : Blocks.field_150484_ah.func_176223_P());
        for (int i3 = 0; i3 < 10; ++i3) {
            double theta = (double)i3 * Math.PI / 5.0;
            xCoords[i3] = centerX + starRadius * Math.sin(theta);
            yCoords[i3] = centerY + starRadius * Math.cos(theta);
        }
        double[] zCoords = new double[10];
        for (i = 0; i < 10; ++i) {
            zCoords[i] = ((double)random.nextFloat() - 0.5) * (double)i * 1.5;
        }
        for (i = 0; i < 10; ++i) {
            this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos.func_189532_c((double)pos.func_177958_n() + xCoords[i], (double)pos.func_177956_o() + ((double)biggestY + 0.5 * (double)smallStarRadius) + yCoords[i], (double)pos.func_177952_p() + zCoords[i]), Blocks.field_180398_cJ.func_176223_P());
        }
        return true;
    }
}

