/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.world.dimension.ConfiguredCarvers;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeatures;
import com.pixelmonmod.pixelmon.world.generation.WorldGenRegistration;
import com.pixelmonmod.pixelmon.world.structure.AbstractPixelmonStructure;
import com.pixelmonmod.pixelmon.world.structure.PixelmonStructureFeatures;
import com.pixelmonmod.pixelmon.world.structure.PixelmonStructures;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AddToBiomes {
    private static Method GETCODEC_METHOD;

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        event.getSpawns().func_242572_a(0.0f);
        String biomeName = event.getName().toString();
        for (RegistryObject<Structure<NoFeatureConfig>> structure : PixelmonStructures.ALL_STRUCTURES) {
            Structure noFeatureConfigStructure = (Structure)structure.get();
            if (noFeatureConfigStructure instanceof AbstractPixelmonStructure && !((AbstractPixelmonStructure)noFeatureConfigStructure).isSuitable(event.getCategory(), biomeName)) continue;
            event.getGeneration().getStructures().add(() -> ((Structure)structure.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.GRASS_GYM);
        }
        if (event.getName().toString().equals("minecraft:nether_wastes")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.FIRE_GYM);
        }
        if (event.getName().toString().equals("minecraft:soul_sand_valley")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.GHOST_GYM);
        }
        if (event.getName().toString().equals("minecraft:birch_forest")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.FAIRY_GYM);
        }
        if (event.getName().toString().equals("minecraft:snowy_tundra")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.ICE_GYM);
        }
        if (event.getName().toString().equals("minecraft:savanna_plateau") || event.getName().toString().equals("minecraft:shattered_savanna") || event.getName().toString().equals("minecraft:shattered_savanna_plateau")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.ELECTRIC_GYM);
        }
        if (event.getName().toString().equals("minecraft:savanna")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.STEEL_GYM);
        }
        if (event.getCategory() == Biome.Category.TAIGA) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.DRAGON_GYM);
        }
        if (event.getCategory() == Biome.Category.OCEAN && event.getName().toString().contains("deep") && event.getName().toString().contains("ocean")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.WATER_GYM);
        }
        if (event.getCategory() == Biome.Category.MESA) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.GROUND_GYM);
        }
        for (WorldGenRegistration.GenerationSettings configuredFeature : WorldGenRegistration.CONFIGURED_FEATURES) {
            if (!configuredFeature.getPredicate().test(event)) continue;
            event.getGeneration().func_242513_a(configuredFeature.getDecoration(), configuredFeature.getFeature());
        }
        if (biomeName.equals("pixelmon:ultra_deep_sea")) {
            event.getGeneration().func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.ULTRA_CAVES);
            event.getGeneration().func_242512_a(GenerationStage.Carving.LIQUID, ConfiguredCarvers.ULTRA_CAVES);
        }
        if (biomeName.equals("pixelmon:ultra_desert")) {
            event.getGeneration().func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.DESERT_CAVES);
            event.getGeneration().func_242512_a(GenerationStage.Carving.LIQUID, ConfiguredCarvers.DESERT_CAVES);
        }
        if (biomeName.equals("pixelmon:ultra_jungle")) {
            DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)event.getGeneration());
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243780_F);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243775_A);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243811_aJ);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.KELP_MANY);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.SEAGRASS_MANY);
        }
        if (biomeName.equals("pixelmon:ultra_forest")) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243789_O);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243780_F);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243775_A);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.SEAGRASS_MANY);
        }
        if (biomeName.equals("pixelmon:ultra_plant")) {
            event.getGeneration().func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.DESERT_CAVES);
            event.getGeneration().func_242512_a(GenerationStage.Carving.LIQUID, ConfiguredCarvers.DESERT_CAVES);
        }
        if (biomeName.equals("pixelmon:ultra_crater")) {
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.CRATER_GYSER);
        }
        if (biomeName.contains("pixelmon:drowned_")) {
            event.getGeneration().func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.DROWNED_WORLD_CAVES);
            event.getGeneration().func_242512_a(GenerationStage.Carving.LIQUID, ConfiguredCarvers.DROWNED_WORLD_CAVES);
        }
        if (biomeName.contains("mount_lanakila")) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.ICE_STONE_ORE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PixelmonFeatures.EVOLUTION_ROCK);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PixelmonFeatures.CANDY_CANE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.TREES_LANAKILA);
            event.getGeneration().func_242516_a(PixelmonStructureFeatures.LANAKILA_VILLAGE);
        }
    }

    @SubscribeEvent
    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        try {
            ResourceLocation cgRL;
            if (GETCODEC_METHOD == null) {
                GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            }
            if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)world.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
        }
        catch (Exception cgRL) {
            // empty catch block
        }
        HashMap tempMap = Maps.newHashMap((Map)world.func_72863_F().func_201711_g().func_235957_b_().field_236193_d_);
        for (RegistryObject<Structure<NoFeatureConfig>> structure : PixelmonStructures.ALL_STRUCTURES) {
            tempMap.putIfAbsent(structure.get(), DimensionStructuresSettings.field_236191_b_.get((Object)structure.get()));
        }
        tempMap.putIfAbsent(PixelmonStructures.GYMS.get(), DimensionStructuresSettings.field_236191_b_.get((Object)PixelmonStructures.GYMS.get()));
        world.func_72863_F().func_201711_g().func_235957_b_().field_236193_d_ = tempMap;
    }
}

