/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;

public abstract class PixelmonDimensionRenderInfo
extends DimensionRenderInfo {
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation CLOUDS_LOCATION = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation END_SKY_LOCATION = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation FORCEFIELD_LOCATION = new ResourceLocation("textures/misc/forcefield.png");
    private static final ResourceLocation RAIN_LOCATION = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = new ResourceLocation("textures/environment/snow.png");

    public PixelmonDimensionRenderInfo(float cloudLevel, boolean hasGround, DimensionRenderInfo.FogType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(cloudLevel, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
        this.setSkyRenderHandler(this::renderSky);
        this.setCloudRenderHandler(this::renderClouds);
        this.setWeatherRenderHandler(this::renderWeather);
        this.setWeatherParticleRenderHandler(this::doWeatherEffects);
    }

    public PixelmonDimensionRenderInfo() {
        this(64.0f, true, DimensionRenderInfo.FogType.NONE, false, false);
    }

    public Vector3d func_230494_a_(Vector3d vec, float time) {
        return vec.func_216372_d((double)(time * 0.94f + 0.06f), (double)(time * 0.94f + 0.06f), (double)(time * 0.91f + 0.09f));
    }

    public boolean func_230493_a_(int x, int z) {
        return true;
    }

    public void renderSky(int ticks, float partialTicks, MatrixStack matrix, ClientWorld world, Minecraft mc) {
        WorldRenderer renderer = mc.field_71438_f;
        RenderSystem.disableTexture();
        Vector3d vector3d = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        renderer.field_175012_t.func_177359_a();
        DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
        renderer.field_175012_t.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        DefaultVertexFormats.field_181705_e.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.func_239132_a_().func_230492_a_(world.func_242415_f(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrix.func_227860_a_();
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            int i = 16;
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrix.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrix.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_242415_f(partialTicks) * 360.0f));
        Matrix4f matrix4f1 = matrix.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        mc.field_71446_o.func_110577_a(SUN_LOCATION);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 20.0f;
        mc.field_71446_o.func_110577_a(MOON_LOCATION);
        int k = world.func_242414_af();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, f12).func_225583_a_(f15, f16).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, f12).func_225583_a_(f13, f16).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, -100.0f, -f12).func_225583_a_(f13, f14).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, -100.0f, -f12).func_225583_a_(f15, f14).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = world.func_228330_j_(partialTicks) * f11;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            renderer.field_175013_s.func_177359_a();
            DefaultVertexFormats.field_181705_e.func_227892_a_(0L);
            renderer.field_175013_s.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_181705_e.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrix.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        if (world.func_239132_a_().func_239216_b_()) {
            RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            RenderSystem.color3f((float)f, (float)f1, (float)f2);
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    public void renderClouds(int ticks, float partialTicks, MatrixStack matrix, ClientWorld world, Minecraft mc, double viewEntityX, double viewEntityY, double viewEntityZ) {
        WorldRenderer renderer = mc.field_71438_f;
        float f = world.func_239132_a_().func_239213_a_();
        if (!Float.isNaN(f)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableDepthTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableFog();
            RenderSystem.depthMask((boolean)true);
            float f1 = 12.0f;
            float f2 = 4.0f;
            double d0 = 2.0E-4;
            double d1 = ((float)ticks + partialTicks) * 0.03f;
            double d2 = (viewEntityX + d1) / 12.0;
            double d3 = f - (float)viewEntityY + 0.33f;
            double d4 = viewEntityZ / 12.0 + (double)0.33f;
            d2 -= (double)(MathHelper.func_76128_c((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(MathHelper.func_76128_c((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)MathHelper.func_76128_c((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)MathHelper.func_76128_c((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)MathHelper.func_76128_c((double)d4));
            Vector3d vector3d = world.func_228328_h_(partialTicks);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != renderer.field_204602_S || j != renderer.field_204603_T || k != renderer.field_204604_U || mc.field_71474_y.func_216842_e() != renderer.field_204800_W || renderer.field_204605_V.func_72436_e(vector3d) > 2.0E-4) {
                renderer.field_204602_S = i;
                renderer.field_204603_T = j;
                renderer.field_204604_U = k;
                renderer.field_204605_V = vector3d;
                renderer.field_204800_W = mc.field_71474_y.func_216842_e();
                renderer.field_204607_y = true;
            }
            if (renderer.field_204607_y) {
                renderer.field_204607_y = false;
                BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
                if (renderer.field_204601_A != null) {
                    renderer.field_204601_A.close();
                }
                renderer.field_204601_A = new VertexBuffer(DefaultVertexFormats.field_181712_l);
                renderer.func_204600_a(bufferbuilder, d2, d3, d4, vector3d);
                bufferbuilder.func_178977_d();
                renderer.field_204601_A.func_227875_a_(bufferbuilder);
            }
            mc.field_71446_o.func_110577_a(CLOUDS_LOCATION);
            matrix.func_227860_a_();
            matrix.func_227862_a_(12.0f, 1.0f, 12.0f);
            matrix.func_227861_a_((double)(-f3), (double)f4, (double)(-f5));
            if (renderer.field_204601_A != null) {
                int i1;
                renderer.field_204601_A.func_177359_a();
                DefaultVertexFormats.field_181712_l.func_227892_a_(0L);
                for (int l = i1 = renderer.field_204800_W == CloudOption.FANCY ? 0 : 1; l < 2; ++l) {
                    if (l == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    renderer.field_204601_A.func_227874_a_(matrix.func_227866_c_().func_227870_a_(), 7);
                }
                VertexBuffer.func_177361_b();
                DefaultVertexFormats.field_181712_l.func_227895_d_();
            }
            matrix.func_227865_b_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.disableFog();
        }
    }

    public void renderWeather(int ticks, float partialTicks, ClientWorld world, Minecraft mc, LightTexture lightmapIn, double xIn, double yIn, double zIn) {
        WorldRenderer renderer = mc.field_71438_f;
        float f = world.func_72867_j(partialTicks);
        if (!(f <= 0.0f)) {
            lightmapIn.func_205109_c();
            int i = MathHelper.func_76128_c((double)xIn);
            int j = MathHelper.func_76128_c((double)yIn);
            int k = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int l = 5;
            if (Minecraft.func_71375_t()) {
                l = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            int i1 = -1;
            float f1 = (float)ticks + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)renderer.field_228411_ak_[l1] * 0.5;
                    double d1 = (double)renderer.field_228412_al_[l1] * 0.5;
                    blockpos$mutable.func_181079_c(k1, 0, j1);
                    Biome biome = world.func_226691_t_((BlockPos)blockpos$mutable);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int i2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutable).func_177956_o();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutable.func_181079_c(k1, j2, j1);
                    float f2 = biome.func_225486_c((BlockPos)blockpos$mutable);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            i1 = 0;
                            mc.func_110434_K().func_110577_a(RAIN_LOCATION);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)k1 + 0.5f) - xIn;
                        double d4 = (double)((float)j1 + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutable.func_181079_c(k1, l2, j1);
                        int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        i1 = 1;
                        mc.func_110434_K().func_110577_a(SNOW_LOCATION);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float f6 = -((float)(ticks & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)((float)k1 + 0.5f) - xIn;
                    double d5 = (double)((float)j1 + 0.5f) - zIn;
                    float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutable.func_181079_c(k1, l2, j1);
                    int k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = (k3 & 0xFFFF) * 3;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                }
            }
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmapIn.func_205108_b();
        }
    }

    public void doWeatherEffects(int ticks, ClientWorld world, Minecraft mc, ActiveRenderInfo activeRenderInfoIn) {
        WorldRenderer renderer = mc.field_71438_f;
        float f = world.func_72867_j(1.0f) / (Minecraft.func_71375_t() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            Random random = new Random((long)ticks * 312987231L);
            BlockPos blockpos = new BlockPos(activeRenderInfoIn.func_216785_c());
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * f * f) / (mc.field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockpos2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(k, 0, l)).func_177977_b();
                Biome biome = world.func_226691_t_(blockpos2);
                if (blockpos2.func_177956_o() <= 0 || blockpos2.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos2.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_225486_c(blockpos2) >= 0.15f)) continue;
                blockpos1 = blockpos2;
                if (mc.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) break;
                double d0 = random.nextDouble();
                double d1 = random.nextDouble();
                BlockState blockstate = world.func_180495_p(blockpos2);
                FluidState fluidstate = world.func_204610_c(blockpos2);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)world, blockpos2);
                double d2 = voxelshape.func_197760_b(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.func_215679_a((IBlockReader)world, blockpos2);
                double d4 = Math.max(d2, d3);
                BasicParticleType iparticledata = !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) && !blockstate.func_203425_a(Blocks.field_196814_hQ) && !CampfireBlock.func_226915_i_((BlockState)blockstate) ? ParticleTypes.field_197600_K : ParticleTypes.field_197601_L;
                world.func_195594_a((IParticleData)iparticledata, (double)blockpos2.func_177958_n() + d0, (double)blockpos2.func_177956_o() + d4, (double)blockpos2.func_177952_p() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && random.nextInt(3) < renderer.field_228410_aj_++) {
                renderer.field_228410_aj_ = 0;
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 1 && world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    world.func_184156_a(blockpos1, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    world.func_184156_a(blockpos1, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }
}

