/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class BlockListeners {
    @SubscribeEvent
    public void onBlockUse(PlayerInteractEvent.RightClickBlock event) throws InvalidQuestArgsException {
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == Hand.MAIN_HAND && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            BlockState state = player.func_71121_q().func_180495_p(event.getPos());
            pps.getQuestData(false).receive("BLOCK_USE", new ItemStack((IItemProvider)state.func_177230_c()), state.func_177230_c());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            BlockState state = event.getState();
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
            if (stack.func_190926_b()) {
                stack = state.func_177230_c() instanceof RedstoneOreBlock ? new ItemStack((IItemProvider)Blocks.field_150450_ax) : new ItemStack((IItemProvider)state.func_177230_c().func_176223_P().func_177230_c());
            }
            pps.getQuestData(false).receive("BLOCK_BREAK", stack, state.func_177230_c());
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) throws InvalidQuestArgsException {
        if (event.getEntity() instanceof ServerPlayerEntity && !(event.getEntity() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            BlockState state = event.getState();
            pps.getQuestData(false).receive("BLOCK_PLACE", new ItemStack((IItemProvider)state.func_177230_c()), state.func_177230_c());
        }
    }
}

