/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BerryItem
extends HeldItem
implements IPlantable {
    private BerryType berry;

    public BerryItem(Item.Properties properties, EnumHeldItems heldItemType, BerryType berry) {
        super(heldItemType, properties.func_200916_a(PixelmonItemGroups.TAB_NATURAL));
        this.berry = berry;
    }

    @Override
    public String getTooltipText() {
        String ret = "";
        String fd = TextFormatting.GOLD + I18n.func_135052_a((String)"berry.flavor.spicy", (Object[])new Object[0]) + ": " + this.berry.spicy + "\n" + TextFormatting.BLUE + I18n.func_135052_a((String)"berry.flavor.sweet", (Object[])new Object[0]) + ": " + this.berry.sweet + "\n" + TextFormatting.RED + I18n.func_135052_a((String)"berry.flavor.sour", (Object[])new Object[0]) + ": " + this.berry.sour + "\n" + TextFormatting.GREEN + I18n.func_135052_a((String)"berry.flavor.bitter", (Object[])new Object[0]) + ": " + this.berry.bitter + "\n" + TextFormatting.YELLOW + I18n.func_135052_a((String)"berry.flavor.dry", (Object[])new Object[0]) + ": " + this.berry.dry + "\n" + TextFormatting.RESET;
        ret = ret + fd;
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".tooltip"))) {
            ret = ret + I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]);
        }
        return ret;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K || this.berry == null) {
            return ActionResultType.SUCCESS;
        }
        if (!PixelmonConfigProxy.getGeneral().isAllowPlanting()) {
            return ActionResultType.FAIL;
        }
        if (!this.berry.isImplemented) {
            return ActionResultType.FAIL;
        }
        BlockState groundBlock = worldIn.func_180495_p(pos);
        if (facing != Direction.UP || groundBlock.func_185904_a() != Material.field_151577_b && groundBlock.func_185904_a() != Material.field_151578_c && groundBlock.func_177230_c() != Blocks.field_150407_cf && groundBlock.func_177230_c() != Blocks.field_150391_bh) {
            return ActionResultType.FAIL;
        }
        if (groundBlock.func_203425_a(Blocks.field_185774_da)) {
            return ActionResultType.FAIL;
        }
        if (!worldIn.func_175623_d(pos.func_177984_a())) {
            return ActionResultType.FAIL;
        }
        if (!playerIn.func_175151_a(pos = pos.func_177984_a(), facing, stack)) {
            return ActionResultType.FAIL;
        }
        if (stack.func_190916_E() <= 0) {
            return ActionResultType.FAIL;
        }
        if (worldIn.func_180495_p(pos).func_196953_a(new BlockItemUseContext(context))) {
            BlockState state = this.berry.getSaplingBlock().func_176223_P();
            worldIn.func_180501_a(pos, state, 11);
            state.func_177230_c().func_180633_a(worldIn, pos, state, (LivingEntity)playerIn, stack);
            SoundType soundtype = state.getSoundType((IWorldReader)worldIn, pos, (Entity)playerIn);
            worldIn.func_184133_a(null, pos, this.getPlaceSound(state, worldIn, pos, playerIn), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!playerIn.func_184812_l_()) {
                if (stack.func_190916_E() <= 1) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.berry.getSaplingBlock().func_176223_P();
    }

    public BerryType getBerry() {
        return this.berry;
    }
}

