/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.events.ThrowPokeballEvent;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.client.models.items.PixelmonISTERs;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokeBallIdPacket;
import com.pixelmonmod.pixelmon.entities.pokeballs.EmptyPokeBallEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class PokeBallItem
extends PixelmonItem
implements PokeBallPart {
    private static final TranslationTextComponent UNKNOWN_BALL = new TranslationTextComponent("item.pixelmon.unknown_poke_ball");

    public PokeBallItem() {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_POKE_BALLS).setISTER(() -> PixelmonISTERs.POKE_BALL_ISTER));
    }

    public static ItemStack of(PokeBall pokeBall) {
        return PokeBallItem.of(pokeBall, 1);
    }

    public static ItemStack of(PokeBall pokeBall, int count) {
        ItemStack stack = new ItemStack((IItemProvider)PixelmonItems.poke_ball, count);
        stack.func_77982_d(new CompoundNBT());
        stack.func_77978_p().func_74778_a("PokeBallID", pokeBall.getName());
        return stack;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return (ITextComponent)PokeBallPart.getPokeBall(stack).map(ITranslatable::getTranslatedName).orElse(UNKNOWN_BALL);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity entityPlayer, Hand handIn) {
        ItemStack itemStack = entityPlayer.func_184586_b(handIn);
        Optional<PokeBall> pokeBall = PokeBallPart.getPokeBall(itemStack);
        if (pokeBall.isPresent()) {
            ThrowPokeballEvent throwPokeBallEvent = new ThrowPokeballEvent(entityPlayer, itemStack, pokeBall.get(), false);
            if (Pixelmon.EVENT_BUS.post((Event)throwPokeBallEvent)) {
                return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
            }
            if (PixelmonServerConfig.allowCapturingOutsideBattle) {
                world.func_184133_a(null, entityPlayer.func_233580_cy_(), (SoundEvent)SoundRegistration.POKEBALL_THROW.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_217376_c((Entity)new EmptyPokeBallEntity(world, (LivingEntity)entityPlayer, pokeBall.get(), !entityPlayer.func_184812_l_()));
                    if (!entityPlayer.func_184812_l_()) {
                        itemStack.func_190918_g(1);
                        entityPlayer.field_71071_by.func_70296_d();
                    }
                }
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        ServerPlayerEntity thrower = userWrapper.getPlayerOwner();
        if (!(targetWrapper.getParticipant() instanceof WildPixelmonParticipant)) {
            return false;
        }
        Optional<PokeBall> pokeBall = PokeBallPart.getPokeBall(stack);
        if (!pokeBall.isPresent()) {
            return false;
        }
        ThrowPokeballEvent throwPokeballEvent = new ThrowPokeballEvent((PlayerEntity)thrower, null, pokeBall.get(), true);
        Pixelmon.EVENT_BUS.post((Event)throwPokeballEvent);
        World world = thrower.field_70170_p;
        EmptyPokeBallEntity p = new EmptyPokeBallEntity(world, (LivingEntity)thrower, targetWrapper.entity, pokeBall.get(), BattleRegistry.getBattle((PlayerEntity)thrower));
        world.func_217376_c((Entity)p);
        userWrapper.bc.sendToPlayers(new SetPokeBallIdPacket(p.func_145782_y()));
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }

    @Override
    public String getTooltipText(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("tooltip")) {
            return nbt.func_74779_i("tooltip");
        }
        return this.getTooltipText(PokeBallPart.getPokeBall(stack).map(pokeBall -> pokeBall.getTranslationKey() + ".tooltip").orElse(""));
    }

    public String getTooltipText(String key) {
        if (!key.isEmpty() && I18n.func_188566_a((String)key)) {
            return I18n.func_135052_a((String)key, (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("[\u2c10\u2517\u2739\u2ae2\u2175\u2cb5\u227c\u2d64\u2363\u2810\u21c6] Poke Ball"));
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    @Override
    public void func_150895_a(ItemGroup p_150895_1_, NonNullList<ItemStack> items) {
        if (this.func_194125_a(p_150895_1_)) {
            for (PokeBall pokeBall : PokeBallRegistry.getAll()) {
                items.add((Object)PokeBallItem.of(pokeBall));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (!stack.func_77978_p().func_74764_b("PokeBallID")) {
            stack.func_77978_p().func_74778_a("PokeBallID", PokeBallRegistry.POKE_BALL.getKey());
        }
    }
}

