/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.furniture.ArmchairBlock;
import com.pixelmonmod.pixelmon.blocks.furniture.BoxBlock;
import com.pixelmonmod.pixelmon.blocks.furniture.ChairBlock;
import com.pixelmonmod.pixelmon.blocks.furniture.CushionChairBlock;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonBlockItem
extends BlockItem {
    public PixelmonBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        return ActionResult.func_226249_b_((Object)p_77659_2_.func_184586_b(p_77659_3_));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack stack = player.func_184586_b(hand);
        BlockState iBlockState = worldIn.func_180495_p(pos);
        Block placedOn = iBlockState.func_177230_c();
        BlockItemUseContext blockItemUseContext = new BlockItemUseContext(context);
        boolean canBeReplaced = placedOn.func_196253_a(worldIn.func_180495_p(pos), blockItemUseContext);
        if (placedOn == Blocks.field_150433_aE && (Integer)iBlockState.func_177229_b((Property)SnowBlock.field_176315_a) < 1) {
            facing = Direction.UP;
        } else if (!canBeReplaced) {
            pos = pos.func_177972_a(facing);
        }
        if (stack.func_190916_E() == 0) {
            return ActionResultType.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return ActionResultType.FAIL;
        }
        if (pos.func_177956_o() == 255 && iBlockState.func_185904_a().func_76220_a()) {
            return ActionResultType.FAIL;
        }
        Direction rot = context.func_195992_f();
        if (!worldIn.func_175623_d(pos) && !canBeReplaced || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this.func_179223_d()) return ActionResultType.FAIL;
        if (this.func_179223_d() instanceof MultiBlock) {
            if (!PixelmonBlockItem.canPlace(pos, rot, worldIn, (MultiBlock)this.func_179223_d(), player, stack, placedOn)) return ActionResultType.FAIL;
            MultiBlock mb = (MultiBlock)this.func_179223_d();
            BlockState iblockstate1 = this.func_179223_d().func_196258_a(blockItemUseContext);
            this.placeBlock(stack, iblockstate1, player, worldIn, pos);
            PixelmonBlockItem.setMultiBlocksWidth(pos, rot, worldIn, mb, this.func_179223_d(), player);
            this.playPlacementSound(worldIn, pos, player);
        } else {
            BlockState iblockstate1 = this.func_179223_d().func_196258_a(blockItemUseContext);
            if (iblockstate1 == null) {
                return ActionResultType.FAIL;
            }
            BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)worldIn.func_234923_W_(), (IWorld)worldIn, (BlockPos)pos), iBlockState, (Entity)player);
            MinecraftForge.EVENT_BUS.post((Event)placeEvent);
            if (placeEvent.isCanceled()) {
                return ActionResultType.FAIL;
            }
            if (this.placeBlock(stack, iblockstate1, player, worldIn, pos)) {
                this.playPlacementSound(worldIn, pos, player);
            }
        }
        if (this.func_179223_d() instanceof IBlockHasOwner) {
            ((IBlockHasOwner)this.func_179223_d()).setOwner(pos, player);
        }
        if (player.func_184812_l_()) return ActionResultType.SUCCESS;
        stack.func_190920_e(stack.func_190916_E() - 1);
        return ActionResultType.SUCCESS;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return super.canEquip(stack, armorType, entity) || armorType == EquipmentSlotType.HEAD && (this.func_179223_d() instanceof CushionChairBlock || this.func_179223_d() instanceof BoxBlock || this.func_179223_d() instanceof ChairBlock || this.func_179223_d() instanceof ArmchairBlock);
    }

    private boolean placeBlock(ItemStack stack, BlockState newState, PlayerEntity player, World world, BlockPos pos) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.func_179223_d()) {
            PixelmonBlockItem.func_179224_a((World)world, (PlayerEntity)player, (BlockPos)pos, (ItemStack)stack);
            this.func_179223_d().func_180633_a(world, pos, state, (LivingEntity)player, stack);
        }
        return true;
    }

    protected boolean func_195944_a(BlockItemUseContext context, BlockState p_195944_2_) {
        if (this.func_179223_d() instanceof MultiBlock) {
            MultiBlock mb = (MultiBlock)this.func_179223_d();
            BlockPos pos2 = context.func_195995_a().func_177972_a(context.func_196000_l());
            return PixelmonBlockItem.canPlace(pos2, context.func_195999_j().func_174811_aO(), context.func_195991_k(), mb, context.func_195999_j(), context.func_195996_i(), context.func_195991_k().func_180495_p(pos2).func_177230_c());
        }
        return super.func_195944_a(context, p_195944_2_);
    }

    public static boolean canPlace(BlockPos pos, Direction rot, World world, MultiBlock mb, PlayerEntity player, ItemStack stack, Block block) {
        int x;
        int n = rot == Direction.NORTH ? 1 : (x = rot == Direction.SOUTH ? -1 : 0);
        int z = rot == Direction.EAST ? 1 : (rot == Direction.WEST ? -1 : 0);
        for (int l = PixelmonBlockItem.getWidthOffset(mb); l < mb.getWidth() + PixelmonBlockItem.getWidthOffset(mb); ++l) {
            if (PixelmonBlockItem.canPlaceLength(pos, x * l, z * l, rot, world, mb, player, stack, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean canPlaceLength(BlockPos pos, int xd, int zd, Direction rot, World world, MultiBlock mb, PlayerEntity player, ItemStack stack, Block block) {
        int x;
        int n = rot == Direction.EAST ? 1 : (x = rot == Direction.WEST ? -1 : 0);
        int z = rot == Direction.NORTH ? -1 : (rot == Direction.SOUTH ? 1 : 0);
        for (int w = 0; w < mb.getLength(); ++w) {
            if (PixelmonBlockItem.canPlaceHeight(pos, xd + w * x, zd + w * z, rot, world, mb, player, stack, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean canPlaceHeight(BlockPos pos, int xd, int zd, Direction rot, World world, MultiBlock mb, PlayerEntity player, ItemStack stack, Block block) {
        int h = 0;
        while ((double)h < mb.getHeight()) {
            BlockPos p = new BlockPos(pos.func_177958_n() + xd, pos.func_177956_o() + h, pos.func_177952_p() + zd);
            BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)p), world.func_180495_p(p.func_177977_b()), (Entity)player);
            MinecraftForge.EVENT_BUS.post((Event)placeEvent);
            if (placeEvent.isCanceled()) {
                return false;
            }
            BlockState iblockstate = world.func_180495_p(p);
            if (!iblockstate.func_185904_a().func_76222_j() && iblockstate.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            ++h;
        }
        return true;
    }

    public static void setMultiBlocksWidth(BlockPos pos, Direction rot, World world, MultiBlock mb, Block block, PlayerEntity player) {
        int x;
        int n = rot == Direction.NORTH ? 1 : (x = rot == Direction.SOUTH ? -1 : 0);
        int z = rot == Direction.EAST ? 1 : (rot == Direction.WEST ? -1 : 0);
        for (int l = PixelmonBlockItem.getWidthOffset(mb); l < mb.getWidth() + PixelmonBlockItem.getWidthOffset(mb); ++l) {
            PixelmonBlockItem.setMultiBlocksLength(pos, x * l, z * l, rot, world, mb, block, player);
        }
    }

    public static int getWidthOffset(MultiBlock mb) {
        return mb.getJsonOffset() ? -1 : 0;
    }

    private static void setMultiBlocksLength(BlockPos pos, int xd, int zd, Direction rot, World world, MultiBlock mb, Block block, PlayerEntity player) {
        int x;
        int n = rot == Direction.EAST ? 1 : (x = rot == Direction.WEST ? -1 : 0);
        int z = rot == Direction.NORTH ? -1 : (rot == Direction.SOUTH ? 1 : 0);
        for (int w = 0; w < mb.getLength(); ++w) {
            PixelmonBlockItem.setMultiBlocksHeight(pos, xd + w * x, zd + w * z, rot, world, mb, block, player);
        }
    }

    private static void setMultiBlocksHeight(BlockPos pos, int xd, int zd, Direction rot, World world, MultiBlock mb, Block block, PlayerEntity player) {
        int h = 0;
        while ((double)h < mb.getHeight()) {
            BlockPos p = new BlockPos(pos.func_177958_n() + xd, pos.func_177956_o() + h, pos.func_177952_p() + zd);
            Direction facing = xd > 0 ? Direction.EAST : (xd < 0 ? Direction.WEST : (zd > 0 ? Direction.SOUTH : (zd < 0 ? Direction.NORTH : rot)));
            MultiBlockPosition multiPos = xd == 0 && zd == 0 && h == 0 ? MultiBlockPosition.BASE : (h == 0 ? MultiBlockPosition.BOTTOM : MultiBlockPosition.TOP);
            BlockState iblockstate1 = (BlockState)((BlockState)block.func_176223_P().func_206870_a(MultiBlock.MULTIPOS, (Comparable)((Object)multiPos))).func_206870_a((Property)MultiBlock.FACING, (Comparable)facing);
            world.func_180501_a(p, iblockstate1, 2);
            ++h;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        String tt = this.getTooltipText(stack);
        if (!tt.isEmpty()) {
            if (ScreenHelper.isKeyDown(340)) {
                for (String s : tt.split("\n")) {
                    tooltip.add((ITextComponent)new StringTextComponent(s));
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.tooltip.collapsed", (Object[])new Object[0])));
            }
        }
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public String getTooltipText(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("tooltip")) {
            return nbt.func_74779_i("tooltip");
        }
        return this.getTooltipText();
    }

    public String getTooltipText() {
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".tooltip"))) {
            return I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]);
        }
        return "";
    }

    private void playPlacementSound(World worldIn, BlockPos pos, PlayerEntity player) {
        SoundType soundType = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), (IWorldReader)worldIn, pos, (Entity)player);
        worldIn.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }
}

