/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokeBallImpactEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class OccupiedPokeBallEntity
extends PokeBallEntity {
    private static final UUID CREATOR_UUID = UUID.fromString("2f723150-24de-44ff-aeee-87c75f7c7a9e");
    private static final int MAX_LIFETIME = 400;
    String pokeName = null;

    public OccupiedPokeBallEntity(EntityType<OccupiedPokeBallEntity> type, World world) {
        super(type, world);
    }

    @Override
    public void spawnRedBeam() {
    }

    public OccupiedPokeBallEntity(World world) {
        this((EntityType<OccupiedPokeBallEntity>)((EntityType)EntityRegistration.OCCUPIED_POKEBALL.get()), world);
        SYNC_MODE.set((Entity)this, (Object)PokeBallMode.FULL);
    }

    public String getPokeNameUnlocalized() {
        PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)this.thrower);
        if (this.getPokeUUID() != null && party.find(this.getPokeUUID()) != null) {
            return party.find(this.getPokeUUID()).getSpecies().getLocalizedName();
        }
        return "";
    }

    public Optional<Species> getPokemon() {
        if (this.thrower == null) {
            return Optional.empty();
        }
        PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)this.thrower);
        if (this.getPokeUUID() != null && party.find(this.getPokeUUID()) != null) {
            return Optional.of(party.find(this.getPokeUUID()).getSpecies());
        }
        return Optional.empty();
    }

    public OccupiedPokeBallEntity(World world, LivingEntity entityliving, int slot, PokeBall type) {
        super((EntityType<? extends PokeBallEntity>)((EntityType)EntityRegistration.OCCUPIED_POKEBALL.get()), type, world, entityliving, PokeBallMode.FULL);
        this.thrower = entityliving;
        this.setOwnerId(this.thrower.func_110124_au());
        this.endRotationYaw = entityliving.field_70759_as;
        SYNC_SLOT.set((Entity)this, (Object)((byte)slot));
        this.setPokeUUID(StorageProxy.getParty((ServerPlayerEntity)entityliving).get(slot).getUUID());
        this.func_70012_b(entityliving.func_226277_ct_(), entityliving.func_226278_cu_() + (double)entityliving.func_70047_e(), entityliving.func_226281_cx_(), entityliving.field_70177_z, entityliving.field_70125_A);
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_234612_a_((Entity)entityliving, entityliving.field_70125_A, entityliving.field_70177_z, 0.0f, 0.90000004f, 1.0f);
        this.setInitialYaw(this.thrower.field_70177_z);
        this.setInitialPitch(this.thrower.field_70125_A);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 400 || this.func_226278_cu_() < 0.0)) {
            this.func_241204_bJ_();
        }
    }

    @Override
    public ITextComponent func_200200_C_() {
        PlayerPartyStorage party;
        Pokemon pokemon;
        if (this.pokeName == null && this.thrower instanceof ServerPlayerEntity && (pokemon = (party = StorageProxy.getParty((ServerPlayerEntity)this.thrower)).find(this.getPokeUUID())) != null) {
            this.pokeName = pokemon.getSpecies().getLocalizedName();
        }
        return new StringTextComponent(this.pokeName + " ").func_230529_a_(super.func_200200_C_());
    }

    @Override
    protected void func_70227_a(RayTraceResult traceResult) {
        VoxelShape bounds;
        BlockPos pos;
        BlockState state;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (traceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !(state = this.field_70170_p.func_180495_p(pos = ((BlockRayTraceResult)traceResult).func_216350_a())).func_185904_a().func_76220_a() && !state.func_224755_d((IBlockReader)this.field_70170_p, pos, ((BlockRayTraceResult)traceResult).func_216354_b()) && (bounds = state.func_196951_e((IBlockReader)this.field_70170_p, pos)).func_197766_b()) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeBallImpactEvent(this, traceResult))) {
            return;
        }
        if (traceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            PixelmonEntity pokemonHit = null;
            if (traceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)traceResult).func_216348_a() != null && ((EntityRayTraceResult)traceResult).func_216348_a() instanceof PixelmonEntity) {
                pokemonHit = (PixelmonEntity)((EntityRayTraceResult)traceResult).func_216348_a();
            }
            if (pokemonHit != null && pokemonHit.getOwner() == this.getEntity() && pokemonHit.func_184207_aI()) {
                return;
            }
            if (((EntityRayTraceResult)traceResult).func_216348_a() == this.getEntity() || this.func_234616_v_() == null) {
                return;
            }
            UUID throwerUUID = this.getOwnerId();
            if (throwerUUID == null || ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(throwerUUID) == null) {
                this.func_241204_bJ_();
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getParty((ServerPlayerEntity)this.thrower);
            Pokemon pokemon = storage.get(this.slot);
            if (pokemon == null) {
                this.func_241204_bJ_();
                return;
            }
            if (pokemon.getSpecies().is(PixelmonSpecies.WOBBUFFET) && CREATOR_UUID.equals(pokemon.getOwnerPlayerUUID())) {
                pokemon.setForm("online");
            }
            if (pokemonHit != null && !Objects.equals(pokemonHit.func_184780_dh(), throwerUUID)) {
                PixelmonEntity target = pokemonHit;
                if (target.battleController != null) {
                    if (target.battleController.checkValid()) {
                        ChatHandler.sendChat(this.func_234616_v_(), "pixelmon.entitypokemon.inbattle", new Object[0]);
                        this.func_241204_bJ_();
                        return;
                    }
                    if (target.getTrainer() != null) {
                        target.func_241204_bJ_();
                        this.func_241204_bJ_();
                        return;
                    }
                }
                if (target.hitByPokeball != null) {
                    this.func_241204_bJ_();
                    return;
                }
                if (target.hasOwner()) {
                    PlayerPartyStorage targetStorage = StorageProxy.getParty(target.func_184780_dh());
                    if (target.getOwner() == null) {
                        this.func_241204_bJ_();
                        return;
                    }
                    if (!targetStorage.battleEnabled) {
                        this.func_241204_bJ_();
                        return;
                    }
                    if (targetStorage.guiOpened) {
                        ChatHandler.sendChat(this.func_234616_v_(), "pixelmon.general.playerbusy", new Object[0]);
                        this.func_241204_bJ_();
                        return;
                    }
                    if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                        new BattleQuery((ServerPlayerEntity)this.func_234616_v_(), this.pixelmon, (ServerPlayerEntity)target.getOwner(), target);
                        this.func_241204_bJ_();
                        return;
                    }
                    PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                    if (pixelmon != null) {
                        pixelmon.setPixelmonToFlyForBattle();
                        Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayerEntity)this.func_234616_v_(), pokemon, pixelmon));
                        pixelmon.onSendout();
                        new BattleQuery((ServerPlayerEntity)this.func_234616_v_(), pixelmon, (ServerPlayerEntity)target.getOwner(), target);
                    }
                } else {
                    if (BattleRegistry.getBattle((PlayerEntity)this.func_234616_v_()) != null) {
                        this.func_241204_bJ_();
                        return;
                    }
                    WildPixelmonParticipant part = new WildPixelmonParticipant(target);
                    if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                        BattleRegistry.startBattle(new BattleParticipant[]{new PlayerParticipant((ServerPlayerEntity)this.func_234616_v_(), pokemon)}, new BattleParticipant[]{part}, new BattleRules(BattleType.SINGLE));
                        this.func_241204_bJ_();
                        return;
                    }
                    PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                    if (pixelmon != null) {
                        pixelmon.setPixelmonToFlyForBattle();
                        pixelmon.onSendout();
                        Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayerEntity)this.func_234616_v_(), pokemon, pixelmon));
                        pixelmon.startBattle(new PlayerParticipant((ServerPlayerEntity)this.func_234616_v_(), pixelmon), part);
                    }
                    this.func_241204_bJ_();
                }
            } else {
                if (traceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)traceResult).func_216348_a() instanceof NPCTrainer) {
                    ServerPlayerEntity throwerPlayer;
                    NPCTrainer trainerEntity = (NPCTrainer)((EntityRayTraceResult)traceResult).func_216348_a();
                    BattleController bc = trainerEntity.getBattleController();
                    if (bc != null) {
                        if (bc.battleEnded) {
                            bc.endBattle(BattleEndCause.FORCE);
                        } else {
                            ChatHandler.sendChat(this.func_234616_v_(), "pixelmon.entitytrainer.inbattle", new Object[0]);
                            this.func_241204_bJ_();
                            return;
                        }
                    }
                    if (!trainerEntity.canStartBattle((PlayerEntity)(throwerPlayer = (ServerPlayerEntity)this.func_234616_v_()), true)) {
                        return;
                    }
                    BattleType battleType = trainerEntity.getBattleType();
                    if (trainerEntity.battleRules.isDefault()) {
                        if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                            PlayerParticipant playerPart;
                            TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (PlayerEntity)this.thrower, battleType.getNumPokemon());
                            if (battleType == BattleType.SINGLE) {
                                playerPart = new PlayerParticipant(throwerPlayer, pokemon);
                            } else {
                                ArrayList<Pokemon> list = new ArrayList<Pokemon>();
                                list.add(pokemon);
                                list.addAll(storage.getTeam().stream().filter(p -> p.getHealth() > 0 && p != pokemon).collect(Collectors.toList()));
                                playerPart = new PlayerParticipant(throwerPlayer, list, 2);
                            }
                            BattleRegistry.startBattle(new BattleParticipant[]{playerPart}, new BattleParticipant[]{trainer}, trainerEntity.battleRules);
                            this.func_241204_bJ_();
                            return;
                        }
                        PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
                        Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, pixelmon));
                        if (pixelmon != null) {
                            PlayerParticipant playerPart;
                            pixelmon.setPixelmonToFlyForBattle();
                            Pixelmon.EVENT_BUS.post((Event)new PokemonSendOutEvent.Post((ServerPlayerEntity)this.func_234616_v_(), pokemon, pixelmon));
                            pixelmon.onSendout();
                            TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (PlayerEntity)this.thrower, battleType.getNumPokemon());
                            if (battleType == BattleType.SINGLE) {
                                playerPart = new PlayerParticipant(throwerPlayer, pixelmon);
                            } else {
                                ArrayList<Pokemon> list = new ArrayList<Pokemon>();
                                list.add(pokemon);
                                list.addAll(storage.getTeam().stream().filter(p -> p.getHealth() > 0 && p != pokemon).collect(Collectors.toList()));
                                playerPart = new PlayerParticipant(throwerPlayer, list, 2);
                            }
                            pixelmon.startBattle((BattleParticipant)playerPart, (BattleParticipant)trainer, trainerEntity.battleRules);
                        }
                    } else {
                        TeamSelectionRegistry.builder().members(new Entity[]{trainerEntity, throwerPlayer}).showRules().showOpponentTeam().closeable().battleRules(trainerEntity.battleRules).start();
                    }
                    this.func_241204_bJ_();
                    return;
                }
                if (PixelmonConfigProxy.getGeneral().isEngagePlayerByPokeBall() && traceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)traceResult).func_216348_a() instanceof ServerPlayerEntity && ((EntityRayTraceResult)traceResult).func_216348_a() != this.func_234616_v_()) {
                    ServerPlayerEntity thrower = (ServerPlayerEntity)this.func_234616_v_();
                    ServerPlayerEntity enemy = (ServerPlayerEntity)((EntityRayTraceResult)traceResult).func_216348_a();
                    PlayerPartyStorage enemyParty = StorageProxy.getParty(enemy);
                    if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(pokemon))) {
                        Pokemon player1FirstPokemon = storage.getFirstBattleReadyPokemon();
                        Pokemon player2FirstPokemon = enemyParty.getFirstBattleReadyPokemon();
                        if (player2FirstPokemon == null) {
                            ChatHandler.sendChat((Entity)thrower, "pixelmon.command.battle.nopokemon", enemy.func_145748_c_());
                        } else if (player1FirstPokemon != null) {
                            new BattleQuery(thrower, player1FirstPokemon, enemy, player2FirstPokemon);
                        }
                        this.func_241204_bJ_();
                        return;
                    }
                    PixelmonEntity player1FirstPixelmonEntity = storage.getAndSendOutFirstAblePokemon((Entity)thrower);
                    Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(pokemon, player1FirstPixelmonEntity));
                    if (enemyParty.guiOpened) {
                        ChatHandler.sendChat((Entity)thrower, "pixelmon.general.playerbusy", new Object[0]);
                        return;
                    }
                    PixelmonEntity player2FirstPixelmonEntity = enemyParty.getAndSendOutFirstAblePokemon((Entity)enemy);
                    if (player2FirstPixelmonEntity == null) {
                        ChatHandler.sendChat((Entity)thrower, "pixelmon.command.battle.nopokemon", enemy.func_145748_c_());
                    } else {
                        new BattleQuery(thrower, player1FirstPixelmonEntity, enemy, player2FirstPixelmonEntity);
                    }
                }
            }
        }
        if (this.getIsWaiting()) {
            this.func_213317_d(Vector3d.field_186680_a);
            this.func_241204_bJ_();
            this.func_174812_G();
            this.setIsOnGround(true);
        } else {
            BlockRayTraceResult blockRayTraceResult;
            if (traceResult instanceof BlockRayTraceResult && (blockRayTraceResult = (BlockRayTraceResult)traceResult).func_216354_b() != Direction.UP) {
                this.func_174812_G();
                return;
            }
            this.setAnimation(AnimationType.BOUNCEOPEN);
            this.setIsWaiting(true);
            this.func_213317_d(Vector3d.field_186680_a);
            this.field_70125_A = 0.0f;
        }
    }
}

