/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.attackAnimations.VariableParticleEffect;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;

public class Smelt {
    public static boolean instaCookForMedHighStrength = true;
    public static List<Optional<ImmutableAttack>> highStrength = Lists.newArrayList((Object[])new Optional[]{AttackRegistry.INFERNO, AttackRegistry.BURN_UP, AttackRegistry.BLUE_FLARE});
    public static List<Optional<ImmutableAttack>> midStrength = Lists.newArrayList((Object[])new Optional[]{AttackRegistry.INCINERATE});

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("smelt").setName("pixelmon.moveskill.smelt").describe("pixelmon.moveskill.smelt.description1", "pixelmon.moveskill.smelt.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/smelt.png")).setDefaultCooldownTicks(2400).setUsePP(true).setRange(8).setAnyMoves("Incinerate", "Inferno", "Ember", "Burn Up", "Blue Flare");
        return moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            BlockPos pos = (BlockPos)tup.func_76341_a();
            BlockState state = pixelmon.field_70170_p.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof AbstractFurnaceBlock)) {
                return -1;
            }
            TileEntity te = pixelmon.field_70170_p.func_175625_s(pos);
            if (!(te instanceof AbstractFurnaceTileEntity)) {
                return -1;
            }
            AbstractFurnaceTileEntity furnace = (AbstractFurnaceTileEntity)te;
            IRecipeType checkType = furnace instanceof SmokerTileEntity ? IRecipeType.field_222152_d : (furnace instanceof BlastFurnaceTileEntity ? IRecipeType.field_222151_c : IRecipeType.field_222150_b);
            int strength = 0;
            for (Optional<ImmutableAttack> highAttack : highStrength) {
                if (!highAttack.isPresent() || !pixelmon.getPokemon().getMoveset().hasAttack(highAttack.get())) continue;
                strength = 32;
                break;
            }
            for (Optional<ImmutableAttack> midAttack : midStrength) {
                if (!midAttack.isPresent() || !pixelmon.getPokemon().getMoveset().hasAttack(midAttack.get())) continue;
                strength = 16;
                break;
            }
            int cooked = 0;
            while (strength > cooked++ && instaCookForMedHighStrength) {
                pixelmon.field_70170_p.func_199532_z().func_215371_a(checkType, (IInventory)furnace, pixelmon.field_70170_p).ifPresent(arg_0 -> ((AbstractFurnaceTileEntity)furnace).func_214007_c(arg_0));
            }
            furnace.field_214013_b.func_221477_a(0, (32 + strength) * 20);
            pixelmon.field_70170_p.func_184148_a(null, (double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.5f), (double)pos.func_177952_p(), SoundEvents.field_187606_E, SoundCategory.BLOCKS, 0.2f, 1.0f);
            ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.GRAY, "pixelmon.moveskill.smelt.use", pixelmon.getLocalizedName());
            new VariableParticleEffect(pixelmon.field_70170_p, AttackAnimationData.beam().setScale(0.25f).setPower(30)).setAttackBase(AttackRegistry.FLAMETHROWER.get()).setStartPosition((LivingEntity)pixelmon).setEndPosition(new Vector3d((double)furnace.func_174877_v().func_177958_n() + 0.5, (double)furnace.func_174877_v().func_177956_o() + 0.5, (double)furnace.func_174877_v().func_177952_p() + 0.5)).showAllWithin(20);
            pixelmon.field_70170_p.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
            return moveSkill.cooldownTicks / (strength == 0 ? 2 : 1);
        });
    }
}

