/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions;

import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.NuggetCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InteractionMeltanNuggets
implements IInteraction {
    @Override
    public boolean processInteract(PixelmonEntity pixelmon, PlayerEntity player, Hand hand, ItemStack itemstack) {
        if (!(player instanceof ServerPlayerEntity) || pixelmon.getOwner() != player || !pixelmon.isPokemon(PixelmonSpecies.MELTAN)) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item != Items.field_191525_da && item != Items.field_151042_j && item != Items.field_221698_bk) {
            return false;
        }
        int required = pixelmon.getForm().getFirstEvolutionConditionOfType(NuggetCondition.class).map(nuggets -> nuggets.nuggets).orElse(-1);
        if (required > 0) {
            pixelmon.getPokemon().getExtraStats(MeltanStats.class).ifPresent(stats -> {
                boolean done = required <= stats.nuggetsFed;
                int result = 0;
                if (!done) {
                    result = stats.feed(itemstack, required);
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    pixelmon.field_70170_p.func_184133_a(null, pixelmon.func_233580_cy_(), (SoundEvent)SoundRegistration.MELTAN_EAT.get(), SoundCategory.NEUTRAL, 1.0f, RandomHelper.getRandom().nextFloat() + 1.0f);
                    pixelmon.getPokemon().markDirty(EnumUpdateType.Meltan_Stats);
                }
                if (result <= 0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.meltan.sated"), Util.field_240973_b_);
                    while (result < 0) {
                        boolean ingot = result <= -9;
                        ItemStack stack = new ItemStack((IItemProvider)(ingot ? Items.field_151042_j : Items.field_191525_da));
                        if (!player.func_191521_c(stack)) {
                            player.func_71019_a(stack, true);
                        }
                        int refund = ingot ? 9 : 1;
                        result += refund;
                        stats.nuggetsFed -= refund;
                    }
                    pixelmon.getPokemon().markDirty(EnumUpdateType.Meltan_Stats);
                }
            });
            return true;
        }
        return false;
    }
}

