/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.drops;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.DropEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHoldsItemsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.eventbus.api.Event;

public class DropItemQueryList {
    public static List<DropItemQuery> queryList = Collections.synchronizedList(new ArrayList());

    public static void register(AbstractHoldsItemsEntity pixelmon, ArrayList<DroppedItem> givenDrops, ServerPlayerEntity player) {
        DropEvent event = new DropEvent(player, (CreatureEntity)pixelmon, pixelmon.isBossPokemon() ? ItemDropMode.Boss : ItemDropMode.NormalPokemon, givenDrops);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        givenDrops = new ArrayList<DroppedItem>((Collection<DroppedItem>)event.getDrops());
        DropItemQuery diq = new DropItemQuery(new Vector3d(pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_()), player.func_110124_au(), givenDrops);
        queryList.add(diq);
        if (pixelmon.isBossPokemon()) {
            NetworkHelper.sendPacket(new ItemDropPacket(ItemDropMode.Boss, givenDrops), player);
        } else {
            NetworkHelper.sendPacket(new ItemDropPacket(ItemDropMode.NormalPokemon, ChatHandler.getMessage("gui.guiItemDrops.beatPokemon", pixelmon.getNickname()), givenDrops), player);
        }
    }

    public static void register(NPCTrainer npc, ArrayList<DroppedItem> givenDrops, ServerPlayerEntity player) {
        DropEvent event = new DropEvent(player, npc, npc.isGymLeader ? ItemDropMode.Other : ItemDropMode.NormalTrainer, givenDrops);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        givenDrops = new ArrayList<DroppedItem>((Collection<DroppedItem>)event.getDrops());
        DropItemQuery diq = new DropItemQuery(new Vector3d(npc.func_226277_ct_(), npc.func_226278_cu_(), npc.func_226281_cx_()), player.func_110124_au(), givenDrops);
        queryList.clear();
        queryList.add(diq);
        ItemDropPacket p = npc.isGymLeader ? new ItemDropPacket(ChatHandler.getMessage("pixelmon.entitytrainer.dropitemstitle", npc.getName(player.getLanguage())), givenDrops) : new ItemDropPacket(ItemDropMode.NormalTrainer, givenDrops);
        NetworkHelper.sendPacket(p, player);
    }

    public static void takeAllItems(ServerPlayerEntity player) {
        for (DropItemQuery query : queryList) {
            if (!query.playerUUID.equals(player.func_110124_au())) continue;
            for (DroppedItem droppedItem : query.droppedItemList) {
                if (droppedItem.drop == null) {
                    DropItemHelper.giveItemStack(player, droppedItem.item, false);
                    continue;
                }
                droppedItem.drop.give(player);
            }
        }
        DropItemQueryList.removeQuery(player);
    }

    public static void dropAllItems(ServerPlayerEntity player) {
        if (!PixelmonConfigProxy.getGeneral().getDrops().isDeleteUnwantedDrops()) {
            for (DropItemQuery dropItemQuery : queryList) {
                if (!dropItemQuery.playerUUID.equals(player.func_110124_au())) continue;
                for (DroppedItem droppedItem : dropItemQuery.droppedItemList) {
                    if (droppedItem.drop == null) {
                        DropItemHelper.dropItemOnGround(dropItemQuery.position, player, droppedItem.item, droppedItem.rarity.isBoss(), false);
                        continue;
                    }
                    droppedItem.drop.drop(player, dropItemQuery.position);
                }
            }
        }
        DropItemQueryList.removeQuery(player);
    }

    public static void takeItem(ServerPlayerEntity player, int itemID) {
        for (int i = 0; i < queryList.size(); ++i) {
            DropItemQuery query = queryList.get(i);
            if (!query.playerUUID.equals(player.func_110124_au())) continue;
            for (int j = 0; j < query.droppedItemList.size(); ++j) {
                DroppedItem droppedItem = query.droppedItemList.get(j);
                if (droppedItem.id != itemID) continue;
                if (droppedItem.drop == null) {
                    DropItemHelper.giveItemStack(player, droppedItem.item, false);
                } else {
                    droppedItem.drop.give(player);
                }
                query.droppedItemList.remove(j);
                if (query.droppedItemList.isEmpty()) {
                    DropItemQueryList.removeQuery(player);
                }
                return;
            }
        }
    }

    public static void removeQuery(ServerPlayerEntity player) {
        for (int i = 0; i < queryList.size(); ++i) {
            if (!DropItemQueryList.queryList.get((int)i).playerUUID.equals(player.func_110124_au())) continue;
            queryList.remove(i);
            --i;
        }
    }
}

