/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelHolder;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.client.render.TexturedEntity;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.TransformPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHasStatsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.PaletteParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.ParticleEffects;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractClientEntity
extends AbstractBaseEntity
implements TexturedEntity {
    public static final int parameterId = Pokemon.SYNC_POKEMON_BASE.getParameterId();
    public static final int parameterId2 = Pokemon.SYNC_GROWTH.getParameterId();
    public static final DataSync<AbstractClientEntity, Integer> SYNC_TRANSFORMATION = new DataSync<AbstractClientEntity, Integer>(AbstractClientEntity.class, DataSerializers.field_187192_b, (abstractClientEntity, integer) -> {
        abstractClientEntity.transformations = integer;
    });
    public static final DataSync<AbstractClientEntity, Float> SYNC_DYNAMAX_SCALE = new DataSync<AbstractClientEntity, Float>(AbstractClientEntity.class, DataSerializers.field_187193_c, (abstractClientEntity, f) -> {
        abstractClientEntity.dynamaxScale = f.floatValue();
    });
    public static final DataSync<AbstractClientEntity, ResourceLocation> SYNC_OVERRIDE_TEXTURE = new DataSync<AbstractClientEntity, ResourceLocation>(AbstractClientEntity.class, PixelmonDataSerializers.RESOURCE_LOCATION, (abstractClientEntity, f) -> {
        abstractClientEntity.overrideTexture = f;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_WIREFRAME = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, DataSerializers.field_187198_h, (abstractMovesEntity, wireFrame) -> {
        abstractMovesEntity.wireFrame = wireFrame;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_ANIMATED = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, DataSerializers.field_187198_h, (abstractMovesEntity, animated) -> {
        abstractMovesEntity.animated = animated;
    });
    public static final DataSync<AbstractClientEntity, Integer> SYNC_MODEL_SLOT = new DataSync<AbstractClientEntity, Integer>(AbstractClientEntity.class, DataSerializers.field_187192_b, (abstractMovesEntity, modelSlot) -> {
        abstractMovesEntity.modelSlot = modelSlot;
    });
    public static final DataSync<AbstractClientEntity, Boolean> SYNC_SPRITE_MODEL = new DataSync<AbstractClientEntity, Boolean>(AbstractClientEntity.class, DataSerializers.field_187198_h, (abstractMovesEntity, spriteModel) -> {
        abstractMovesEntity.spriteModel = spriteModel;
    });
    public static final DataSync<AbstractClientEntity, EvolutionStage> SYNC_EVO_STAGE = new DataSync<AbstractClientEntity, EvolutionStage>(AbstractClientEntity.class, PixelmonDataSerializers.EVO_STAGE, (abstractMovesEntity, evoStage) -> {
        abstractMovesEntity.evoStage = evoStage;
    });
    private static final int animationFlyingDelayLimit = 10;
    private static final int animationDelayLimit = 3;
    static int flyingDelayLimit = 10;
    public PokemonBase transformed = null;
    public ResourceLocation transformedTexture = null;
    public PaletteParticles transformedParticles = null;
    boolean animationFlyingCounting = false;
    boolean animationFlyingSwap = false;
    boolean animationCounting = false;
    boolean animationSwap = false;
    int animationFlyingDelayCounter = 0;
    int animationDelayCounter = 0;
    int flyingDelayCounter = 0;
    private AnimationVariables animationVariables;
    private AnimationType animationType;
    protected ResourceLocation overrideTexture;
    protected EvolutionStage evoStage = null;
    private int transformations = -1;
    private float dynamaxScale = 0.0f;
    protected boolean wireFrame = false;
    protected boolean animated = true;
    protected boolean spriteModel = false;
    protected int modelSlot = 0;
    public int evolvingVal = 0;
    public int evoAnimTicks = 0;
    public int fadeCount = 0;
    private boolean fadeDirection = true;
    public float heightDiff;
    public float widthDiff;
    public float lengthDiff;
    private final float[] renderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public AbstractClientEntity(EntityType<? extends AbstractClientEntity> type, World par1World) {
        super(type, par1World);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.define(SYNC_TRANSFORMATION, 0);
        this.define(SYNC_DYNAMAX_SCALE, Float.valueOf(0.0f));
        this.define(SYNC_OVERRIDE_TEXTURE, null);
        this.define(SYNC_WIREFRAME, false);
        this.define(SYNC_ANIMATED, true);
        this.define(SYNC_MODEL_SLOT, 0);
        this.define(SYNC_SPRITE_MODEL, false);
        this.define(SYNC_EVO_STAGE, null);
    }

    @Override
    @Nonnull
    public ResourceLocation getTexture() {
        if (this.overrideTexture != null) {
            return this.overrideTexture;
        }
        if (this.transformedTexture != null) {
            return this.transformedTexture;
        }
        return this.getRealTexture();
    }

    public boolean isWireFrame() {
        return this.wireFrame;
    }

    public void setWireFrame(boolean wireFrame) {
        SYNC_WIREFRAME.set((Entity)this, (Object)wireFrame);
    }

    public boolean isAnimated() {
        return this.animated && PixelmonConfigProxy.getGraphics().isGlobalAnimationToggle();
    }

    public void setAnimated(boolean animated) {
        SYNC_ANIMATED.set((Entity)this, (Object)animated);
    }

    public void setOverrideTexture(ResourceLocation overrideTexture) {
        SYNC_OVERRIDE_TEXTURE.set((Entity)this, (Object)overrideTexture);
    }

    public ResourceLocation getTextureNoCheck() {
        if (this.overrideTexture != null) {
            return this.overrideTexture;
        }
        if (this.transformedTexture != null) {
            return this.transformedTexture;
        }
        return this.getRealTexture();
    }

    @Override
    public Pokemon getPokemon() {
        Pokemon pokemon = super.getPokemon();
        if (pokemon == null) {
            this.pokemon = PokemonFactory.create(PixelmonSpecies.BULBASAUR.getValueUnsafe());
            return this.pokemon;
        }
        return pokemon;
    }

    public ResourceLocation getRealTexture() {
        if (this.pokemon == null) {
            return PixelmonSpecies.BULBASAUR.getValueUnsafe().getDefaultForm().getGenderProperties(Gender.NONE).getPalettes()[0].getTexture();
        }
        return this.pokemon.getPalette().getTexture();
    }

    public ResourceLocation getSprite() {
        return this.getPokemon().getPalette().getSprite();
    }

    public void evolve(PokemonSpecification evolveTo) {
        if (!evolveTo.getValue(SpeciesRequirement.class).isPresent()) {
            return;
        }
        RegistryValue<Species> evolvedTo = evolveTo.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO);
        if (this.getPokemon().getSpecies().is(PixelmonSpecies.MAGIKARP) && this.getPokemon().isPalette("roasted")) {
            this.pokemon.setSpecies(evolvedTo, true);
            this.pokemon.setPalette("zombie");
        }
        this.pokemon.setSpecies(evolvedTo, true);
        this.update(EnumUpdateType.Name, EnumUpdateType.Nickname);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Model getModel() {
        if (this.transformed != null) {
            return this.transformed.getPalette().getModel(this).getModel();
        }
        if (this.getPalette() == null) {
            PixelmonModelHolder<?> modelHolder = PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getModel(this);
            if (modelHolder == null) {
                return null;
            }
            return modelHolder.getModel();
        }
        PixelmonModelHolder<?> model = this.getPalette().getModel(this);
        if (model == null) {
            Pixelmon.LOGGER.error("Null model in species " + this.getSpecies().getName() + ", form " + this.getForm().getName() + ", palette " + this.getPalette().getName() + ", gender " + this.getGenderProperties().getGender().name());
            return null;
        }
        return model.getModel();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void transform(Species transformedModel, String transformedForm, String transformedTexture, String transformedParticles) {
        this.transformed = new PokemonBase(transformedModel, transformedModel.getForm(transformedForm), Gender.MALE);
        this.transformedTexture = ResourceLocationHelper.of(transformedTexture);
        this.transformedParticles = new PaletteParticles(ParticleSystems.get(ResourceLocationHelper.of(transformedParticles)));
    }

    public void cancelTransform() {
        this.transformed = null;
        this.transformedTexture = null;
        this.transformedParticles = null;
        this.updateTransformed();
    }

    public void updateTransformed() {
        PaletteParticles particles;
        TransformPacket transform = this.transformed != null ? (this.transformedParticles != null && this.transformedParticles.getParticleSystem() != null && this.transformedParticles.getParticleSystem().getResource() != null ? new TransformPacket(this.func_145782_y(), this.transformed.getSpecies(), this.transformedTexture.toString(), this.transformed.getForm().getName(), this.transformedParticles.getParticleSystem().getResource().toString()) : new TransformPacket(this.func_145782_y(), this.transformed.getSpecies(), this.transformedTexture.toString(), this.transformed.getForm().getName(), "")) : ((particles = this.pokemon.getPalette().getParticle()) != null && particles.getParticleSystem() != null && particles.getParticleSystem().getResource() != null ? new TransformPacket(this.func_145782_y(), this.pokemon.getSpecies(), this.getRealTexture().toString(), this.pokemon.getForm().getName(), particles.getParticleSystem().getResource().toString()) : new TransformPacket(this.func_145782_y(), this.pokemon.getSpecies(), this.getRealTexture().toString(), this.pokemon.getForm().getName(), ""));
        NetworkHelper.sendToAll(transform);
    }

    public void transformServer(Species transformedModel, String form, String texture, String particles) {
        this.transformed = new PokemonBase(transformedModel, transformedModel.getForm(form), Gender.MALE);
        this.transformedTexture = ResourceLocationHelper.of(texture);
        this.transformedParticles = new PaletteParticles(ParticleSystems.get(ResourceLocationHelper.of(particles)));
        this.updateTransformed();
    }

    public int getTransformed() {
        return this.transformations;
    }

    public float getScaleFactor() {
        if (this.getPokemon() == null || this.getPokemon().getGrowth() == null || this.getBossTier() == null) {
            return 1.0f;
        }
        return (float)Math.pow(this.getPokemon().getGrowth().scaleValue, PixelmonConfigProxy.getGeneral().getGrowthScaleModifier()) * this.getBossTier().getModelScaleFactor();
    }

    public float getDynamaxScale() {
        return this.dynamaxScale;
    }

    public void setDynamaxScale(float scale) {
        SYNC_DYNAMAX_SCALE.set((Entity)this, (Object)Float.valueOf(Math.max(0.0f, scale)));
    }

    public void addDynamaxScale(float scale) {
        SYNC_DYNAMAX_SCALE.set((Entity)this, (Object)Float.valueOf(this.getDynamaxScale() + scale));
    }

    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    public void initAnimation() {
        ValveStudioModel model;
        Model base;
        if (this.field_70170_p.field_72995_K && (base = this.getModel()) instanceof PixelmonModelSmd && (model = ((PixelmonModelSmd)base).theModel) != null) {
            model.animate();
        }
    }

    protected void func_180466_bG(ITag<Fluid> p_180466_1_) {
        if (!this.getPokemon().getForm().hasType(Element.WATER) && this.getPokemon().getForm().getMovement().getSwimmingParameters() == null && this.field_70170_p.func_234923_W_() != DrownedWorld.WORLD) {
            super.func_180466_bG(p_180466_1_);
        }
    }

    public void checkAnimation() {
        IncrementingVariable inc;
        if (!(this.getModel() instanceof PixelmonModelSmd)) {
            return;
        }
        PixelmonModelSmd smdModel = (PixelmonModelSmd)this.getModel();
        AbstractHasStatsEntity pixelmon = (AbstractHasStatsEntity)this;
        float f1 = pixelmon.field_184618_aE + (pixelmon.field_70721_aZ - pixelmon.field_184618_aE) * 1.0f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        if ((inc = this.getAnimationVariables().getCounter(-1)) == null) {
            this.getAnimationVariables().setCounter(-1, 2.1474836E9f, smdModel.animationIncrement);
        } else {
            inc.increment = smdModel.animationIncrement;
        }
        if (!pixelmon.animationCounting) {
            this.setAnimation(AnimationType.IDLE);
            pixelmon.animationCounting = true;
        }
        if (pixelmon.func_70090_H() && !pixelmon.field_70122_E) {
            if (f1 > smdModel.movementThreshold) {
                if (pixelmon.animationSwap) {
                    this.setAnimation(AnimationType.SWIM);
                }
            } else if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.IDLE_SWIM);
            }
        } else if (!pixelmon.field_70122_E) {
            if (!pixelmon.animationFlyingSwap) {
                pixelmon.animationFlyingCounting = true;
            }
            if (pixelmon.animationFlyingSwap) {
                this.setAnimation(AnimationType.FLY);
            }
        } else if (f1 > smdModel.movementThreshold) {
            if (pixelmon.animationSwap) {
                this.setAnimation(AnimationType.WALK);
            }
        } else if (pixelmon.animationSwap) {
            this.setAnimation(AnimationType.IDLE);
        }
        if (smdModel.theModel != null && smdModel.theModel.currentSequence == null) {
            this.setAnimation(AnimationType.IDLE);
        }
    }

    public void setAnimation(AnimationType animation) {
        this.animationType = animation;
    }

    public AnimationType getCurrentAnimation() {
        if (this.animationType == null) {
            return AnimationType.IDLE;
        }
        return this.animationType;
    }

    public void func_70030_z() {
        if (this.getPalette() == null) {
            return;
        }
        ModelLocator[] modelLocators = this.getPalette().getModelLocators();
        for (int i = 0; i < modelLocators.length; ++i) {
            ModelLocator modelLocator = modelLocators[i];
            if (!modelLocator.getPredicate().shouldUseModel(this)) continue;
            if (this.getModelSlot() == i) break;
            this.setModelSlot(i);
            break;
        }
        super.func_70030_z();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (!this.func_82150_aj() && !(this instanceof StatueEntity)) {
                for (ParticleEffects particleEffect : ParticleEffects.getParticleEffects(this)) {
                    particleEffect.onUpdate(this);
                }
            }
            this.tickEvolveAnimation();
            if (this.animationVariables != null && this.isAnimated()) {
                this.animationVariables.tick();
            }
            if (this.animationFlyingCounting) {
                if (this.animationFlyingDelayCounter < 10) {
                    ++this.animationFlyingDelayCounter;
                    this.animationFlyingSwap = false;
                }
                if (this.animationFlyingDelayCounter >= 10) {
                    this.animationFlyingSwap = true;
                    this.animationFlyingDelayCounter = 0;
                }
            } else {
                this.animationFlyingDelayCounter = 0;
                this.animationFlyingSwap = false;
            }
            if (!this.field_70122_E && !this.func_70090_H()) {
                if (this.flyingDelayCounter < flyingDelayLimit) {
                    ++this.flyingDelayCounter;
                }
            } else {
                this.flyingDelayCounter = 0;
            }
            if (this.animationCounting) {
                if (this.animationDelayCounter < 3) {
                    ++this.animationDelayCounter;
                    this.animationSwap = false;
                }
                if (this.animationDelayCounter >= 3) {
                    this.animationSwap = true;
                    this.animationDelayCounter = 0;
                }
            } else {
                this.animationDelayCounter = 0;
                this.animationSwap = false;
            }
            if (this instanceof PixelmonEntity) {
                this.checkAnimation();
            }
        }
    }

    public void setEvoStage(EvolutionStage evoStage) {
        SYNC_EVO_STAGE.set((Entity)this, (Object)evoStage);
    }

    public EvolutionStage getEvoStage() {
        return this.evoStage;
    }

    public boolean isEvolving() {
        return this.getEvoStage() != null && this.getEvoStage() != EvolutionStage.End;
    }

    public void setEvolutionAnimationStage(EvolutionStage stage) {
        if (stage == EvolutionStage.End) {
            this.setEvoStage(null);
            this.updateSize();
        } else {
            this.setEvoStage(stage);
            this.evoAnimTicks = 0;
            if (stage == EvolutionStage.PreChoice) {
                this.fadeCount = 20;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEvolveAnimation() {
        ++this.evoAnimTicks;
        if (this.evoStage == null) {
            return;
        }
        ++this.evoAnimTicks;
        Dimensions dimensions = this.getForm().getDimensions();
        if (this.evoStage == EvolutionStage.Choice) {
            if (this.fadeDirection) {
                ++this.fadeCount;
                if (this.fadeCount >= 20) {
                    this.fadeDirection = false;
                }
            } else {
                --this.fadeCount;
                if (this.fadeCount <= 0) {
                    this.fadeDirection = true;
                }
            }
        } else if (this.evoStage == EvolutionStage.PreAnimation) {
            if (this.fadeDirection) {
                if (this.fadeCount < 20) {
                    ++this.fadeCount;
                }
            } else if (this.fadeCount > 0 && this.fadeCount <= 0) {
                this.fadeDirection = true;
            }
        }
        if (this.evoStage == EvolutionStage.Choice || this.evoStage == EvolutionStage.PreAnimation) {
            Random random = this.func_70681_au();
            int numEffects = random.nextInt(10);
            for (int i = 0; i < numEffects; ++i) {
                Color color = RandomHelper.getRandomHighSaturationColor();
                this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), 1.0f), this.func_226277_ct_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), this.func_226278_cu_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getHeight(), this.func_226281_cx_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), 0.0, 0.0, 0.0);
            }
        }
        if (this.evoStage == EvolutionStage.PreAnimation || this.evoStage == EvolutionStage.PostAnimation) {
            if (this.evoStage == EvolutionStage.PreAnimation) {
                if (this.evoAnimTicks > EvolutionStage.PreAnimation.ticks) {
                    --this.evoAnimTicks;
                }
            } else {
                if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks) {
                    --this.evoAnimTicks;
                }
                if (this.evoAnimTicks > EvolutionStage.PostAnimation.ticks - 21 && this.fadeCount > 0) {
                    --this.fadeCount;
                }
            }
            int ticks = this.evoAnimTicks;
            if (this.evoStage == EvolutionStage.PostAnimation) {
                ticks += EvolutionStage.PreAnimation.ticks;
            }
            Random random = this.func_70681_au();
            int numEffects = random.nextInt(50);
            for (int i = 0; i < numEffects; ++i) {
                Color color = RandomHelper.getRandomHighSaturationColor();
                this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), 1.0f), this.func_226277_ct_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), this.func_226278_cu_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getHeight(), this.func_226281_cx_() + (double)(random.nextFloat() * 2.2f - 1.0f) * dimensions.getWidth(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        this.func_226288_n_(x, y, z);
        if (this.field_70180_af == null) {
            return;
        }
        this.updateSize();
    }

    public float func_213307_e(Pose pose) {
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        Dimensions dimensions = this.getForm().getDimensions();
        return Math.max(0.2f, dimensions.getEyeHeight() * scale);
    }

    @Override
    public void initBaseEntity() {
        super.initBaseEntity();
        this.updateSize();
    }

    public void updateSize() {
        if (this.field_70180_af == null) {
            return;
        }
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = 1.0f;
        if (this.getForm() != null) {
            scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
            Dimensions dimensions = this.getForm().getDimensions();
            this.func_174826_a(dimensions.createBoundingBox((Entity)this, scale));
        } else {
            float halfWidth = this.func_213311_cf() * scale / 2.0f;
            this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - (double)halfWidth, this.func_226278_cu_(), this.func_226281_cx_() - (double)halfWidth, this.func_226277_ct_() + (double)halfWidth, this.func_226278_cu_() - this.func_70033_W() + (double)this.func_213302_cg() * (double)scale, this.func_226281_cx_() + (double)halfWidth));
        }
    }

    protected SoundEvent func_184639_G() {
        return this.getPokemon().getPalette().getSound();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (Pixelmon.isDevEnvironment()) {
            nbt.func_74778_a("DebugTexture", this.getTexture().toString());
        }
        if (this.overrideTexture != null) {
            nbt.func_74778_a("PokeOverrideTexture", this.overrideTexture.toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("PokeOverrideTexture")) {
            this.overrideTexture = ResourceLocationHelper.of(nbt.func_74779_i("PokeOverrideTexture"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderColor(float ... renderColor) {
        System.arraycopy(renderColor, 0, this.renderColor, 0, 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getRenderColor() {
        return this.renderColor;
    }

    public int getModelSlot() {
        return this.modelSlot;
    }

    public void setModelSlot(int modelSlot) {
        SYNC_MODEL_SLOT.set((Entity)this, (Object)modelSlot);
    }

    public boolean isSpriteModel() {
        return this.spriteModel;
    }

    public void setSpriteModel(boolean spriteModel) {
        SYNC_SPRITE_MODEL.set((Entity)this, (Object)spriteModel);
    }

    @Override
    public void resetDataWatchers() {
        super.resetDataWatchers();
        SYNC_DYNAMAX_SCALE.set((Entity)this, (Object)Float.valueOf(0.0f));
        SYNC_TRANSFORMATION.set((Entity)this, (Object)0);
    }

    public int getFlyingDelayCounter() {
        return this.flyingDelayCounter;
    }
}

