/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.util.JSONUtils;

public class NPCRegistryVillagers {
    void loadVillager(NPCRegistryData thisData, String name, JsonElement element) {
        try {
            JsonObject jsonelement1;
            int i;
            JsonArray jsonarray;
            GeneralNPCData data = new GeneralNPCData(name);
            JsonObject json = element.getAsJsonObject();
            if (json.has("skins")) {
                jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)"skins");
                for (i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String skin = jsonelement1.get("filename").getAsString();
                    data.addTexture(skin);
                }
            }
            if (json.has("names")) {
                jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)"names");
                for (i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    String npcname = jsonelement1.get("name").getAsString();
                    data.addName(npcname);
                }
            }
            if (json.has("chat")) {
                jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)"chat");
                for (i = 0; i < jsonarray.size(); ++i) {
                    jsonelement1 = jsonarray.get(i).getAsJsonObject();
                    JsonArray lines = jsonelement1.get("lines").getAsJsonArray();
                    ArrayList<String> lineList = new ArrayList<String>();
                    for (int j = 0; j < lines.size(); ++j) {
                        JsonObject object = lines.get(j).getAsJsonObject();
                        String text = object.get("text").getAsString();
                        lineList.add(text);
                    }
                    String[] lineArray = new String[lineList.size()];
                    lineArray = lineList.toArray(lineArray);
                    data.addChat(lineArray);
                }
            }
            thisData.npcs.add(data);
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Error in villager " + name + "_" + thisData.locale, (Throwable)e);
        }
    }

    public GeneralNPCData getNext(String index) {
        ArrayList<GeneralNPCData> npcListUs = ServerNPCRegistry.getEnglishNPCs();
        if (npcListUs.isEmpty()) {
            return null;
        }
        for (int i = 0; i < npcListUs.size(); ++i) {
            if (!npcListUs.get((int)i).id.equals(index)) continue;
            return npcListUs.get((i + 1) % npcListUs.size());
        }
        return npcListUs.get(0);
    }

    public GeneralNPCData getData(String id) {
        ArrayList<GeneralNPCData> npcListUs = ServerNPCRegistry.getEnglishNPCs();
        if (npcListUs.isEmpty()) {
            return null;
        }
        for (GeneralNPCData data : npcListUs) {
            if (!id.equals(data.id)) continue;
            return data;
        }
        return null;
    }

    public GeneralNPCData getRandom() {
        return RandomHelper.getRandomElementFromList(ServerNPCRegistry.getEnglishNPCs());
    }

    public GeneralNPCData getTranslatedData(String langCode, String id) {
        NPCRegistryData translatedData = ServerNPCRegistry.data.get(langCode);
        if (translatedData != null) {
            for (GeneralNPCData npc : translatedData.npcs) {
                if (!npc.id.equals(id)) continue;
                return npc;
            }
        }
        for (GeneralNPCData npc : ServerNPCRegistry.getEnglishNPCs()) {
            if (!npc.id.equals(id)) continue;
            return npc;
        }
        return null;
    }

    public String getTranslatedName(String langCode, String id, int index) {
        ArrayList<String> names = this.getTranslatedData((String)langCode.toLowerCase((Locale)Locale.ROOT), (String)id).names;
        if (index >= names.size()) {
            index = 0;
        }
        return names.get(index);
    }

    public String[] getTranslatedChat(String langCode, String id, int index) {
        ArrayList<String[]> chat = this.getTranslatedData((String)langCode.toLowerCase((Locale)Locale.ROOT), (String)id).chat;
        if (index >= chat.size()) {
            index = 0;
        }
        return chat.get(index);
    }
}

