/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.custom;

import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class PixelmonPaintingEntity
extends HangingEntity {
    public static final DataSync<PixelmonPaintingEntity, ItemStack> SYNC_ITEM_STACK = new DataSync<PixelmonPaintingEntity, ItemStack>(PixelmonPaintingEntity.class, DataSerializers.field_187196_f, (pixelmonPaintingEntity, itemStack) -> {
        pixelmonPaintingEntity.item = itemStack;
    });
    private ItemStack item;
    protected EntityDataSyncManager dataSyncManager;

    public PixelmonPaintingEntity(EntityType<PixelmonPaintingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public PixelmonPaintingEntity(World world) {
        this((EntityType<PixelmonPaintingEntity>)((EntityType)EntityRegistration.PAINTING.get()), world);
    }

    public PixelmonPaintingEntity(World worldIn, BlockPos pos, Direction facing) {
        super((EntityType)EntityRegistration.PAINTING.get(), worldIn, pos);
        this.func_174859_a(facing);
    }

    protected void func_70088_a() {
        this.dataSyncManager = new EntityDataSyncManager();
        this.dataSyncManager.define((Entity)this, SYNC_ITEM_STACK, ItemStack.field_190927_a);
    }

    public void func_70037_a(CompoundNBT compound) {
        CompoundNBT nbt2 = compound.func_74775_l("Item");
        if (!nbt2.isEmpty()) {
            this.setDisplayedItemWithUpdate(ItemStack.func_199557_a((CompoundNBT)nbt2), false);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.getDisplayedItem() != null) {
            compound.func_218657_a("Item", (INBT)this.getDisplayedItem().func_77955_b(new CompoundNBT()));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.getDisplayedItem() == null && !stack.func_190926_b() && stack.func_77973_b() == PixelmonItems.pixelmon_sprite.getItem()) {
            this.setDisplayedItem(stack);
            stack.func_190918_g(1);
            if (!player.func_184812_l_() && stack.func_190916_E() <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_110128_b(Entity brokenEntity) {
        this.dropItemOrSelf(brokenEntity, true);
    }

    public void dropItemOrSelf(Entity p_146065_1_, boolean p_146065_2_) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            PlayerEntity entityplayer;
            ItemStack itemstack = this.getDisplayedItem();
            if (p_146065_1_ instanceof PlayerEntity && (entityplayer = (PlayerEntity)p_146065_1_).func_184812_l_()) {
                return;
            }
            if (p_146065_2_) {
                this.func_70099_a(new ItemStack((IItemProvider)PixelmonItems.item_frame.getItem()), 0.0f);
            }
            if (itemstack != null) {
                itemstack = itemstack.func_77946_l();
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public void func_174856_o() {
        if (this.field_70170_p.field_72995_K) {
            this.field_174860_b = Direction.func_176733_a((double)this.field_70177_z);
        }
        if (this.field_174860_b != null) {
            double x = (double)this.field_174861_a.func_177958_n() + 0.5;
            double y = (double)this.field_174861_a.func_177956_o() + 0.5;
            double z = (double)this.field_174861_a.func_177952_p() + 0.5;
            super.func_226288_n_(x, y, z);
            if (this.field_174860_b == Direction.NORTH) {
                this.func_174826_a(new AxisAlignedBB(x - 1.5, y - 1.5, z + 0.3, x + 0.5, y + 0.5, z + 0.5));
            } else if (this.field_174860_b == Direction.SOUTH) {
                this.func_174826_a(new AxisAlignedBB(x - 0.5, y - 1.5, z - 0.3, x + 1.5, y + 0.5, z - 0.5));
            } else if (this.field_174860_b == Direction.EAST) {
                this.func_174826_a(new AxisAlignedBB(x - 0.3, y - 1.5, z - 1.5, x - 0.5, y + 0.5, z + 0.5));
            } else {
                this.func_174826_a(new AxisAlignedBB(x + 0.3, y - 1.5, z - 0.5, x + 0.5, y + 0.5, z + 1.5));
            }
        }
    }

    public int func_82329_d() {
        return 32;
    }

    public int func_82330_g() {
        return 32;
    }

    public boolean func_70518_d() {
        return true;
    }

    private void setDisplayedItemWithUpdate(ItemStack stack, boolean p_174864_2_) {
        if (stack != null) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        SYNC_ITEM_STACK.set((Entity)this, (Object)stack);
        if (p_174864_2_ && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    public void setDisplayedItem(ItemStack stack) {
        this.setDisplayedItemWithUpdate(stack, true);
    }

    public ItemStack getDisplayedItem() {
        return this.item != ItemStack.field_190927_a ? this.item : null;
    }

    public void func_184523_o() {
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

