/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config.starter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.lang.reflect.Type;

public class ColorTypeAdapter
implements JsonSerializer<Color>,
JsonDeserializer<Color> {
    private static final ColorTypeAdapter INSTANCE = new ColorTypeAdapter();

    public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        return new Color(object.get("r").getAsInt(), object.get("g").getAsInt(), object.get("b").getAsInt(), object.get("a").getAsInt());
    }

    public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("r", (Number)src.getRed());
        object.addProperty("g", (Number)src.getGreen());
        object.addProperty("b", (Number)src.getBlue());
        object.addProperty("a", (Number)src.getAlpha());
        return object;
    }

    public static Color getColor(JsonElement color) {
        return INSTANCE.deserialize(color, null, null);
    }

    public static JsonElement toJson(Color color) {
        return INSTANCE.serialize(color, null, null);
    }
}

