/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerStats;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.SendEntireDayCarePacket;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PokeRestartCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"prestart"});

    public PokeRestartCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokerestart", "/pokerestart [player] <--confirm>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length < 1) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        PCStorage pc = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (Arrays.stream(args).noneMatch(it -> it.contains("--confirm"))) {
            PixelmonCommandUtils.endCommand("pixelmon.command.pokerestart.noconfirm", new Object[0]);
        }
        this.restartPlayer(target, storage, pc);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokerestart.success", target.func_145748_c_().getString()), false);
    }

    private void restartPlayer(ServerPlayerEntity target, PlayerPartyStorage storage, PCStorage pc) {
        storage.retrieveAll("Command");
        for (Pokemon pokemon : storage.getAll()) {
            if (pokemon == null) continue;
            storage.set(pokemon.getPosition(), null);
        }
        for (Pokemon pokemon : pc.getAll()) {
            if (pokemon == null) continue;
            pc.set(pokemon.getPosition(), null);
        }
        storage.getDayCare().reset();
        storage.starterPicked = false;
        storage.playerPokedex.wipe();
        storage.stats = new PlayerStats();
        NetworkHelper.sendPacket(target, new SendEntireDayCarePacket(storage.getDayCare()));
        TickHandler.registerStarterList(target);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

