/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public class DoLegendarySpawnCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"legendaryspawn", "spawnlegendary"});
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_legendary_spawn_%d").build());

    public DoLegendarySpawnCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "dolegendaryspawn", "/dolegendaryspawn [player]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if (ServerLifecycleHooks.getCurrentServer().func_184103_al().func_72394_k() == 0) {
            PixelmonCommandUtils.endCommand("spawning.error.nooneisonline", new Object[0]);
        }
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        ServerPlayerEntity target = args.length == 1 ? (StringUtils.equalsAnyIgnoreCase((CharSequence)args[0], (CharSequence[])new CharSequence[]{"any", "random"}) ? (ServerPlayerEntity)RandomHelper.getRandomElementFromList(players) : PixelmonCommandUtils.requireEntityPlayer(args[0])) : (sender.func_197022_f() instanceof ServerPlayerEntity ? sender.func_197035_h() : (ServerPlayerEntity)RandomHelper.getRandomElementFromList(players));
        boolean isCoordinatorActive = PixelmonSpawning.coordinator.getActive();
        AbstractSpawner abstrSpawner = PixelmonSpawning.coordinator.getSpawner("legendary");
        if (abstrSpawner == null) {
            abstrSpawner = PixelmonSpawning.legendarySpawner;
        }
        LegendarySpawner spawner = (LegendarySpawner)PixelmonCommandUtils.require(abstrSpawner, "spawning.error.legendaryspawnermissing", new Object[0]);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GRAY, "spawning.attemptlegendaryspawn", new Object[0]), false);
        if (isCoordinatorActive) {
            spawner.forcefullySpawn(target);
        } else {
            this.forcefullySpawn(target, spawner);
        }
        Runnable r = () -> {
            if (spawner.possibleSpawns != null && !spawner.possibleSpawns.isEmpty()) {
                spawner.possibleSpawns.forEach(spawn -> {
                    spawn.spawnInfo.tags.forEach(BetterSpawnerConfig.intervalTimes::remove);
                    ServerLifecycleHooks.getCurrentServer().execute(() -> spawn.doSpawn(spawner));
                });
                spawner.possibleSpawns = null;
            } else {
                PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.effect.effectfailed", new Object[0]);
                PixelmonCommandUtils.sendMessage(sender, TextFormatting.GRAY, "/checkspawns legendary", new Object[0]);
            }
        };
        if (isCoordinatorActive) {
            SpawnerCoordinator.PROCESSOR.execute(r);
        } else {
            EXECUTOR_SERVICE.execute(r);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }

    private void forcefullySpawn(@Nullable ServerPlayerEntity onlyFocus, LegendarySpawner spawner) {
        ArrayList<ArrayList<ServerPlayerEntity>> clusters = new ArrayList<ArrayList<ServerPlayerEntity>>();
        ArrayList<ServerPlayerEntity> players = new ArrayList<ServerPlayerEntity>(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
        if (onlyFocus == null) {
            while (!players.isEmpty()) {
                ArrayList<ServerPlayerEntity> cluster = new ArrayList<ServerPlayerEntity>();
                ServerPlayerEntity focus = (ServerPlayerEntity)players.remove(0);
                cluster.add(focus);
                LegendarySpawner.fillNearby(players, cluster, focus);
                clusters.add(cluster);
            }
        }
        spawner.isBusy = true;
        EXECUTOR_SERVICE.execute(() -> {
            if (onlyFocus != null) {
                spawner.possibleSpawns = spawner.doLegendarySpawn(onlyFocus).join();
            } else {
                Collections.shuffle(clusters);
                while (clusters.size() > 0) {
                    for (int i = 0; i < clusters.size(); ++i) {
                        ServerPlayerEntity player = (ServerPlayerEntity)CollectionHelper.getRandomElement((List)clusters.get(i));
                        ((ArrayList)clusters.get(i)).remove(player);
                        if (((ArrayList)clusters.get(i)).isEmpty()) {
                            clusters.remove(i--);
                        }
                        if (spawner.firesChooseEvent) {
                            LegendarySpawnEvent.ChoosePlayer event = new LegendarySpawnEvent.ChoosePlayer(spawner, player, clusters);
                            if (Pixelmon.EVENT_BUS.post((Event)event) || event.player == null) continue;
                            player = event.player;
                        }
                        spawner.possibleSpawns = spawner.doLegendarySpawn(player).join();
                        if (spawner.possibleSpawns == null) continue;
                        spawner.isBusy = false;
                        return;
                    }
                }
            }
            spawner.isBusy = false;
        });
    }
}

