/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorIndividualScreen;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class UpdateSinglePokemonPacket
extends AbstractPixelmonPacket {
    private int slot;
    private Pokemon pokemon;

    public UpdateSinglePokemonPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public UpdateSinglePokemonPacket(int slot, Pokemon pokemon) {
        super(PacketDirection.PLAY_SERVER);
        this.slot = slot;
        this.pokemon = pokemon;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.slot);
        boolean hasPokemon = this.pokemon != null;
        buf.writeBoolean(hasPokemon);
        if (hasPokemon) {
            this.pokemon.writeToByteBuffer(buf, EnumUpdateType.ALL);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.slot = buf.readInt();
        if (buf.readBoolean()) {
            this.pokemon = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.ALL);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (this.pokemon != null) {
            this.pokemon.setStorage(ClientStorageManager.party, new StoragePosition(-1, this.slot));
        }
        ServerStorageDisplay.editedPokemon.set(this.slot, this.pokemon);
        if (Minecraft.func_71410_x().field_71462_r instanceof PokemonEditorIndividualScreen) {
            PokemonEditorIndividualScreen gui = (PokemonEditorIndividualScreen)Minecraft.func_71410_x().field_71462_r;
            if (this.pokemon != null && gui.getPokemonSingle().getUUID().equals(this.pokemon.getUUID())) {
                gui.setPokemon(this.pokemon);
            }
        }
    }
}

