/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeleteTrainerPokemonPacket
extends AbstractPixelmonPacket {
    private int trainerID;
    private int position;

    public DeleteTrainerPokemonPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DeleteTrainerPokemonPacket(int trainerID, int position) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerID = trainerID;
        this.position = position;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.trainerID);
        buffer.writeInt(this.position);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.trainerID = buffer.readInt();
        this.position = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (!NPCEditorItem.checkPermission((PlayerEntity)context.getSender())) {
            return;
        }
        DeleteTrainerPokemonPacket.deletePokemon(this.trainerID, this.position, context, true);
    }

    public static void deletePokemon(int trainerID, int position, NetworkEvent.Context context, boolean updateClient) {
        ServerPlayerEntity player = context.getSender();
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.field_70170_p, trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer t = entityNPCOptional.get();
        TrainerPartyStorage storage = t.getPokemonStorage();
        if (storage.getTeam().size() <= position) {
            return;
        }
        Pokemon pokemon = storage.getTeam().get(position);
        if (storage.countAll() > 1) {
            storage.set(pokemon.getPosition().order, null);
        }
        t.updateTrainerLevel();
        if (updateClient) {
            storage.sendCacheToPlayer(player);
        }
    }
}

