/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeleteTrainerPacket
extends AbstractPixelmonPacket {
    private int trainerId;

    public DeleteTrainerPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DeleteTrainerPacket(int trainerId) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerId = trainerId;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.trainerId);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.trainerId = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity p = context.getSender();
        if (!NPCEditorItem.checkPermission((PlayerEntity)p)) {
            return;
        }
        Optional<NPCEntity> npc = NPCEntity.locateNPCServer(p.field_70170_p, this.trainerId, NPCEntity.class);
        npc.ifPresent(NPCEntity::unloadEntity);
    }
}

