/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CreateNPCPacket
extends AbstractPixelmonPacket {
    private EnumNPCType type;
    private BlockPos pos;
    private float rotation;

    public CreateNPCPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public CreateNPCPacket(EnumNPCType type, BlockPos pos, float rotation) {
        super(PacketDirection.PLAY_SERVER, true);
        this.type = type;
        this.pos = pos;
        this.rotation = rotation;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.type = EnumNPCType.getFromOrdinal(buf.readByte());
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readFloat();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeFloat(this.rotation);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (!NPCEditorItem.checkPermission((PlayerEntity)player)) {
            return;
        }
        BlockPos blockPos = this.pos;
        float rotationYaw = this.rotation;
        switch (this.type) {
            case Trainer: {
                NPCTrainer trainer = new NPCTrainer(player.field_70170_p);
                trainer.init(NPCRegistryTrainers.Steve);
                trainer.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                trainer.setAIMode(EnumTrainerAI.StandStill);
                trainer.initAI();
                player.field_70170_p.func_217376_c((Entity)trainer);
                trainer.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                trainer.setStartRotationYaw(rotationYaw + 180.0f);
                trainer.func_110163_bv();
                this.reply(context, new ClearTrainerPokemonPacket());
                for (int i = 0; i < trainer.getPokemonStorage().countAll(); ++i) {
                    this.reply(context, new StoreTrainerPokemonPacket(trainer.getPokemonStorage().get(i)));
                }
                SetTrainerData trainerData = new SetTrainerData(trainer, player.getLanguage());
                this.reply(context, new SetNPCEditDataPacket(trainerData));
                OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.TrainerEditor, trainer.getNPCID());
                break;
            }
            case Trader: {
                NPCTrader trader = new NPCTrader(player.field_70170_p);
                trader.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                player.field_70170_p.func_217376_c((Entity)trader);
                trader.func_110163_bv();
                break;
            }
            case ChattingNPC: {
                NPCChatting npc = new NPCChatting(player.field_70170_p);
                GeneralNPCData data = ServerNPCRegistry.villagers.getRandom();
                npc.init(data);
                npc.initDefaultAI();
                npc.setCustomSteveTexture(data.getRandomTexture());
                npc.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                npc.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)npc);
                break;
            }
            case QuestGiver: {
                NPCQuestGiver questGiver = new NPCQuestGiver(player.field_70170_p);
                GeneralNPCData data2 = ServerNPCRegistry.villagers.getRandom();
                questGiver.init(data2);
                questGiver.initDefaultAI();
                questGiver.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                questGiver.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)questGiver);
                questGiver.setCustomSteveTexture(data2.getRandomTexture());
                break;
            }
            case Relearner: {
                NPCRelearner relearner = new NPCRelearner(player.field_70170_p);
                relearner.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                relearner.setAIMode(EnumTrainerAI.StandStill);
                relearner.initAI();
                relearner.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)relearner);
                break;
            }
            case Tutor: {
                NPCTutor tutor = new NPCTutor(player.field_70170_p);
                tutor.init("Tutor");
                tutor.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                tutor.setAIMode(EnumTrainerAI.StandStill);
                tutor.initAI();
                tutor.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)tutor);
                break;
            }
            case TransferTutor: {
                NPCTutor transfer = new NPCTutor(player.field_70170_p);
                transfer.init("Tutor");
                transfer.setTutorType(EnumNPCTutorType.TRANSFER);
                transfer.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                transfer.setAIMode(EnumTrainerAI.StandStill);
                transfer.initAI();
                transfer.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)transfer);
                break;
            }
            case Shopkeeper: {
                ShopkeeperData shopData = ServerNPCRegistry.shopkeepers.getRandom();
                if (shopData == null) {
                    return;
                }
                NPCShopkeeper shopkeeper = new NPCShopkeeper(player.field_70170_p);
                shopkeeper.init(shopData);
                shopkeeper.initDefaultAI();
                shopkeeper.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                shopkeeper.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)shopkeeper);
                break;
            }
            case NurseJoy: {
                NPCNurseJoy nursejoy = new NPCNurseJoy(player.field_70170_p, 1);
                nursejoy.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                nursejoy.initDefaultAI();
                nursejoy.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)nursejoy);
                break;
            }
            case Doctor: {
                NPCNurseJoy doctor = new NPCNurseJoy(player.field_70170_p, 0);
                doctor.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                doctor.initDefaultAI();
                doctor.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)doctor);
                break;
            }
            case OldFisherman: {
                NPCFisherman fisherman = new NPCFisherman(player.field_70170_p);
                fisherman.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                fisherman.initDefaultAI();
                fisherman.func_110163_bv();
                player.field_70170_p.func_217376_c((Entity)fisherman);
                break;
            }
            case TCGTrader: {
                NPCChatting tcgTrader = new NPCChatting(player.field_70170_p);
                GeneralNPCData tcgTraderData = ServerNPCRegistry.villagers.getRandom();
                tcgTrader.init(tcgTraderData);
                tcgTrader.initDefaultAI();
                tcgTrader.setCustomSteveTexture(tcgTraderData.getRandomTexture());
                tcgTrader.func_70107_b((float)blockPos.func_177958_n() + 0.5f, blockPos.func_177956_o() + 1, (float)blockPos.func_177952_p() + 0.5f);
                tcgTrader.func_110163_bv();
                tcgTrader.getPersistentData().func_74757_a("TCGTrader", true);
                player.field_70170_p.func_217376_c((Entity)tcgTrader);
            }
        }
    }
}

