/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue;

import com.pixelmonmod.pixelmon.client.gui.custom.dialogue.DialogueInputScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenDialogueInputPacket
extends AbstractPixelmonPacket {
    protected ITextComponent title;
    protected ITextComponent text;
    protected String defaultText;
    protected boolean shouldCloseOnEsc;

    public OpenDialogueInputPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenDialogueInputPacket(ITextComponent title, ITextComponent text, String defaultText, boolean shouldCloseOnEsc) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.title = title;
        this.text = text;
        this.defaultText = defaultText;
        this.shouldCloseOnEsc = shouldCloseOnEsc;
    }

    @Override
    public void decode(PacketBuffer buf) {
        PacketBuffer pb = new PacketBuffer((ByteBuf)buf);
        this.title = pb.func_179258_d();
        this.text = pb.func_179258_d();
        this.defaultText = pb.func_150789_c(50);
        this.shouldCloseOnEsc = pb.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        PacketBuffer pb = new PacketBuffer((ByteBuf)buf);
        pb.func_179256_a(this.title);
        pb.func_179256_a(this.text);
        pb.func_180714_a(this.defaultText);
        pb.writeBoolean(this.shouldCloseOnEsc);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DialogueInputScreen(this.title, this.text, this.defaultText, this.shouldCloseOnEsc));
    }
}

