/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.custom.drops;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.gui.custom.CustomDropsScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class CustomDropsOpenPacket
extends AbstractPixelmonPacket {
    private String mnemonic;
    private boolean escapeCloses;
    private ITextComponent title;
    private List<ItemStack> items;
    private ITextComponent[] buttons;

    public CustomDropsOpenPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public CustomDropsOpenPacket(String mnemonic, boolean escapeCloses, ITextComponent title, List<ItemStack> items, ITextComponent ... buttons) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.mnemonic = mnemonic;
        this.escapeCloses = escapeCloses;
        this.title = title;
        this.items = items;
        this.buttons = buttons;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int i;
        this.mnemonic = buffer.func_218666_n();
        this.escapeCloses = buffer.readBoolean();
        this.title = buffer.func_179258_d();
        this.items = Lists.newArrayList();
        int size = buffer.readByte();
        for (i = 0; i < size; ++i) {
            this.items.add(buffer.func_150791_c());
        }
        this.buttons = new ITextComponent[3];
        for (i = 0; i < 3; ++i) {
            this.buttons[i] = buffer.func_179258_d();
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        int i;
        buffer.func_180714_a(this.mnemonic);
        buffer.writeBoolean(this.escapeCloses);
        buffer.func_179256_a(this.title);
        buffer.writeByte(this.items.size());
        for (i = 0; i < this.items.size(); ++i) {
            buffer.func_150788_a(this.items.get(i));
        }
        for (i = 0; i < 3; ++i) {
            buffer.func_179256_a(this.buttons[i]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CustomDropsScreen(this.mnemonic, this.escapeCloses, this.title, this.items.toArray(new ItemStack[0]), this.buttons));
    }
}

