/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetBattlingPokemonPacket
extends AbstractPixelmonPacket {
    private UUID[] pokemon;

    public SetBattlingPokemonPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetBattlingPokemonPacket(List<PixelmonWrapper> arrayList) {
        super(PacketDirection.PLAY_CLIENT, true);
        int numPokemon = arrayList.size();
        this.pokemon = new UUID[numPokemon];
        for (int i = 0; i < numPokemon; ++i) {
            PixelmonWrapper pw = arrayList.get(i);
            if (pw == null) continue;
            this.pokemon[i] = pw.getPokemonUUID();
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.pokemon.length);
        for (UUID uuid : this.pokemon) {
            buffer.func_179252_a(uuid);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int size = buffer.readShort();
        this.pokemon = new UUID[size];
        for (int i = 0; i < size; ++i) {
            this.pokemon[i] = buffer.func_179253_g();
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.setTeamPokemon(this.pokemon);
    }
}

