/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RidingMovementPacket
extends AbstractPixelmonPacket {
    private List<EnumKeybinds> movementList;

    public RidingMovementPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RidingMovementPacket(List<EnumKeybinds> movements) {
        super(PacketDirection.PLAY_SERVER, true);
        this.movementList = movements;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int numMovements = buffer.readShort();
        this.movementList = new ArrayList<EnumKeybinds>();
        for (int i = 0; i < numMovements; ++i) {
            this.movementList.add(EnumKeybinds.getMovement(buffer.readShort()));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.movementList.size());
        for (EnumKeybinds aMovement : this.movementList) {
            buffer.writeShort(aMovement.ordinal());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player.func_184187_bx() instanceof AbstractMovesEntity) {
            ((AbstractMovesEntity)player.func_184187_bx()).handleMovement(this.movementList);
        }
    }
}

