/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class QueryResourceLocationResult
extends AbstractPixelmonPacket {
    private UUID query;
    private boolean found;

    public QueryResourceLocationResult() {
        super(PacketDirection.PLAY_SERVER);
    }

    public QueryResourceLocationResult(UUID query, boolean found) {
        this();
        this.query = query;
        this.found = found;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.query = buf.func_179253_g();
        this.found = buf.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.query);
        buf.writeBoolean(this.found);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            if (context.getSender() != null) {
                PlayerPartyStorage pps = StorageProxy.getParty(context.getSender());
                pps.receiveResourceLocationQueryResult(this.query, this.found);
            }
        });
    }
}

