/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.AttackData;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenReplaceMoveScreenPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String attackId;
    private boolean checkEvo;

    public OpenReplaceMoveScreenPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenReplaceMoveScreenPacket(UUID pokemonUUID, ImmutableAttack move) {
        this(pokemonUUID, move.getAttackName(), false);
    }

    public OpenReplaceMoveScreenPacket(UUID pokemonUUID, ImmutableAttack move, boolean checkEvo) {
        this(pokemonUUID, move.getAttackName(), checkEvo);
    }

    public OpenReplaceMoveScreenPacket(UUID pokemonUUID, String attackId, boolean checkEvo) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.checkEvo = checkEvo;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.pokemonUUID = buf.func_179253_g();
        this.attackId = buf.func_218666_n();
        this.checkEvo = buf.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.pokemonUUID);
        buf.func_180714_a(this.attackId);
        buf.writeBoolean(this.checkEvo);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        AttackData attackData = new AttackData(this.pokemonUUID, new Attack(this.attackId), this.checkEvo);
        if (ClientProxy.battleManager.newAttackList.contains(attackData)) {
            return;
        }
        ClientProxy.battleManager.newAttackList.add(attackData);
        if (!(Minecraft.func_71410_x().field_71462_r instanceof BattleScreen) && !(Minecraft.func_71410_x().field_71462_r instanceof EvolveScreen)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new BattleScreen());
        }
    }
}

