/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MysteryBoxBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.MysteryBoxTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderTileEntityMysteryBox
extends TileEntityRenderer<MysteryBoxTileEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/entity/mystery_box/mystery_box.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228638_b_((ResourceLocation)TEXTURE);
    private final ModelRenderer[] lid = new ModelRenderer[3];
    private final ModelRenderer[] bottom = new ModelRenderer[4];
    private final ModelRenderer[] tabs = new ModelRenderer[2];

    public RenderTileEntityMysteryBox(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.init();
    }

    public RenderTileEntityMysteryBox() {
        this(null);
    }

    private void init() {
        this.bottom[0] = new ModelRenderer(128, 128, 0, 34);
        this.bottom[0].func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.bottom[1] = new ModelRenderer(128, 128, 56, 45);
        this.bottom[1].func_228301_a_(6.0f, 5.0f, 5.0f, 4.0f, 7.0f, 6.0f, 0.0f);
        this.bottom[2] = new ModelRenderer(128, 128, 0, 53);
        this.bottom[2].func_228301_a_(1.0f, 5.0f, 1.0f, 5.0f, 7.0f, 14.0f, 0.0f);
        this.bottom[3] = new ModelRenderer(128, 128, 38, 53);
        this.bottom[3].func_228301_a_(10.0f, 5.0f, 1.0f, 5.0f, 7.0f, 14.0f, 0.0f);
        this.lid[0] = new ModelRenderer(128, 128, 0, 0);
        this.lid[0].func_228301_a_(-7.0f, 12.0f, -7.0f, 5.0f, 2.0f, 14.0f, 0.0f);
        this.lid[1] = new ModelRenderer(128, 128, 0, 16);
        this.lid[1].func_228301_a_(2.0f, 12.0f, -7.0f, 5.0f, 2.0f, 14.0f, 0.0f);
        this.lid[2] = new ModelRenderer(128, 128, 38, 26);
        this.lid[2].func_228301_a_(-2.0f, 12.0f, -3.0f, 4.0f, 2.0f, 6.0f, 0.0f);
        this.lid[2].field_78798_e = 8.0f;
        this.lid[2].field_78800_c = 8.0f;
        this.lid[1].field_78798_e = 8.0f;
        this.lid[1].field_78800_c = 8.0f;
        this.lid[0].field_78798_e = 8.0f;
        this.lid[0].field_78800_c = 8.0f;
        this.tabs[0] = new ModelRenderer(128, 128, 38, 0);
        this.tabs[0].func_228301_a_(0.0f, 0.0f, -4.0f, 4.0f, 9.0f, 4.0f, 0.0f);
        this.tabs[0].field_78800_c = 6.0f;
        this.tabs[0].field_78797_d = 5.0f;
        this.tabs[0].field_78798_e = 15.0f;
        this.tabs[1] = new ModelRenderer(128, 128, 38, 13);
        this.tabs[1].func_228301_a_(0.0f, 0.0f, 0.0f, 4.0f, 9.0f, 4.0f, 0.0f);
        this.tabs[1].field_78800_c = 6.0f;
        this.tabs[1].field_78797_d = 5.0f;
        this.tabs[1].field_78798_e = 1.0f;
    }

    public void render(MysteryBoxTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World level = te.func_145831_w();
        if (level == null || te.func_195044_w().func_177230_c() instanceof MysteryBoxBlock) {
            matrix.func_227860_a_();
            float f = level == null ? 0.0f : ((Direction)te.func_195044_w().func_177229_b((Property)MysteryBoxBlock.FACING)).func_185119_l();
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
            IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
            this.render(matrix, builder, te.getOpenness(), combinedLight, combinedOverlay);
            matrix.func_227865_b_();
        }
    }

    private void render(MatrixStack matrix, IVertexBuilder builder, float[] openness, int combinedLight, int combinedOverlay) {
        this.lid[1].field_78797_d = this.lid[2].field_78797_d = 2.5f * Math.min(1.0f, openness[0]);
        this.lid[0].field_78797_d = this.lid[2].field_78797_d;
        this.lid[1].field_78796_g = this.lid[2].field_78796_g = openness[1];
        this.lid[0].field_78796_g = this.lid[2].field_78796_g;
        this.tabs[0].field_78795_f = 0.05f * openness[0];
        this.tabs[1].field_78795_f = -0.05f * openness[0];
        for (ModelRenderer lid : this.lid) {
            lid.func_228308_a_(matrix, builder, combinedLight, combinedOverlay);
        }
        for (ModelRenderer tabs : this.tabs) {
            tabs.func_228308_a_(matrix, builder, combinedLight, combinedOverlay);
        }
        for (ModelRenderer bottom : this.bottom) {
            bottom.func_228308_a_(matrix, builder, combinedLight, combinedOverlay);
        }
    }
}

