/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.TextureCoordinate;
import com.pixelmonmod.pixelmon.client.models.smd.Vertex;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;

public class NormalizedFace {
    public DeformVertex[] vertices;
    public TextureCoordinate[] textureCoordinates;
    public Vertex faceNormal;

    public NormalizedFace(DeformVertex[] xyz, TextureCoordinate[] uvs) {
        this.vertices = xyz;
        this.textureCoordinates = uvs;
    }

    public NormalizedFace(NormalizedFace face, List<DeformVertex> verts) {
        this.vertices = new DeformVertex[face.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = verts.get(face.vertices[i].ID);
        }
        this.textureCoordinates = new TextureCoordinate[face.textureCoordinates.length];
        System.arraycopy(face.textureCoordinates, 0, this.textureCoordinates, 0, this.textureCoordinates.length);
        if (face.faceNormal != null) {
            this.faceNormal = face.faceNormal;
        }
    }

    public Vertex calculateFaceNormal() {
        Vector3d v1 = new Vector3d((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vector3d v2 = new Vector3d((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vector3d normalVector = null;
        normalVector = v1.func_72431_c(v2).func_72432_b();
        return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }

    public void addFaceForRender(MatrixStack matrixStack, IVertexBuilder bufferBuilder, int packedLight, int packedOverlay, boolean smoothShading, float partialTick, float r, float g, float b, float a) {
        if (!smoothShading && this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        for (int i = 0; i < 3; ++i) {
            Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
            Matrix3f normal = matrixStack.func_227866_c_().func_227872_b_();
            DeformVertex vertex = this.vertices[i];
            if (!(bufferBuilder instanceof BufferBuilder)) {
                bufferBuilder.func_225588_a_(pose.field_226575_a_ * vertex.getX(partialTick) + pose.field_226576_b_ * vertex.getY(partialTick) + pose.field_226577_c_ * vertex.getZ(partialTick) + pose.field_226578_d_, pose.field_226579_e_ * vertex.getX(partialTick) + pose.field_226580_f_ * vertex.getY(partialTick) + pose.field_226581_g_ * vertex.getZ(partialTick) + pose.field_226582_h_, pose.field_226583_i_ * vertex.getX(partialTick) + pose.field_226584_j_ * vertex.getY(partialTick) + pose.field_226585_k_ * vertex.getZ(partialTick) + pose.field_226586_l_, r, g, b, a, this.textureCoordinates[i].u, this.textureCoordinates[i].v, packedOverlay, packedLight, normal.field_226097_a_ * vertex.getXN(partialTick) + normal.field_226098_b_ * vertex.getYN(partialTick) + normal.field_226099_c_ * vertex.getZN(partialTick), normal.field_226100_d_ * vertex.getXN(partialTick) + normal.field_226101_e_ * vertex.getYN(partialTick) + normal.field_226102_f_ * vertex.getZN(partialTick), normal.field_226103_g_ * vertex.getXN(partialTick) + normal.field_226104_h_ * vertex.getYN(partialTick) + normal.field_226105_i_ * vertex.getZN(partialTick));
                continue;
            }
            ByteBuffer buffer = ((BufferBuilder)bufferBuilder).field_179001_a;
            if (vertex.id2 != -1) {
                buffer.position(vertex.id2 * DefaultVertexFormats.field_227849_i_.func_177338_f());
                buffer.limit(vertex.id2 * DefaultVertexFormats.field_227849_i_.func_177338_f() + DefaultVertexFormats.field_227849_i_.func_177338_f());
                ByteBuffer byteBuffer = buffer.slice();
                byteBuffer.limit(DefaultVertexFormats.field_227849_i_.func_177338_f());
                buffer.limit(buffer.capacity());
                ((BufferBuilder)bufferBuilder).putBulkData(byteBuffer);
                ((BufferBuilder)bufferBuilder).func_181670_b(DefaultVertexFormats.field_227849_i_.func_177338_f());
                continue;
            }
            bufferBuilder.func_225588_a_(pose.field_226575_a_ * vertex.getX(partialTick) + pose.field_226576_b_ * vertex.getY(partialTick) + pose.field_226577_c_ * vertex.getZ(partialTick) + pose.field_226578_d_, pose.field_226579_e_ * vertex.getX(partialTick) + pose.field_226580_f_ * vertex.getY(partialTick) + pose.field_226581_g_ * vertex.getZ(partialTick) + pose.field_226582_h_, pose.field_226583_i_ * vertex.getX(partialTick) + pose.field_226584_j_ * vertex.getY(partialTick) + pose.field_226585_k_ * vertex.getZ(partialTick) + pose.field_226586_l_, r, g, b, a, this.textureCoordinates[i].u, this.textureCoordinates[i].v, packedOverlay, packedLight, normal.field_226097_a_ * vertex.getXN(partialTick) + normal.field_226098_b_ * vertex.getYN(partialTick) + normal.field_226099_c_ * vertex.getZN(partialTick), normal.field_226100_d_ * vertex.getXN(partialTick) + normal.field_226101_e_ * vertex.getYN(partialTick) + normal.field_226102_f_ * vertex.getZN(partialTick), normal.field_226103_g_ * vertex.getXN(partialTick) + normal.field_226104_h_ * vertex.getYN(partialTick) + normal.field_226105_i_ * vertex.getZN(partialTick));
            vertex.id2 = ((BufferBuilder)bufferBuilder).field_178997_d - 1;
        }
    }
}

