/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.spawner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.spawner.PixelmonSpawnerScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.SlotBase;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class PokemonListScreen
extends SlotBase {
    public PixelmonSpawnerScreen gui;
    public Pokemon selectedPokemon;

    public PokemonListScreen(PixelmonSpawnerScreen gui, int width, int height, int top, int left) {
        super(top, left, width, height, true);
        this.gui = gui;
        this.slotHeight = 20;
    }

    @Override
    protected void elementClicked(int index, boolean doubleClicked) {
        if (index == -1) {
            return;
        }
        this.selectedPokemon = this.gui.ps.pokemonList.get((int)index).pokemon.create();
        this.selectedPokemon.setGrowth(EnumGrowth.Ordinary);
    }

    @Override
    protected void drawSlot(MatrixStack matrix, int index, int x, int yTop, int yMiddle) {
        PokemonRarity r = this.gui.getPokemonListEntry(index);
        if (r == null) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int percentageXAddition = font.func_78256_a(String.valueOf(this.gui.getBiggestRarity()));
        int biggestSpec = this.gui.getBiggestSpec(30);
        int specXAddition = biggestSpec - 30;
        if (r.pokemon.toString().length() > 30) {
            font.func_238421_b_(matrix, r.pokemon.toString().substring(0, 31) + "...", (float)(x + 40), (float)yTop, 0);
        } else {
            font.func_238421_b_(matrix, r.pokemon.toString(), (float)(x + 40), (float)yTop, 0);
        }
        if (r.getSprite() != null) {
            ScreenHelper.drawImageQuad(r.getSprite(), matrix, x + 10, yTop - 1, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        font.func_238421_b_(matrix, "" + r.rarity, (float)(x + 95 + specXAddition), (float)yTop, 0);
        font.func_238421_b_(matrix, this.gui.getPercentage(index) + "%", (float)(x + 125 + percentageXAddition + specXAddition), (float)yTop, 0);
        font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.weight", (Object[])new Object[0]), (float)(x + 95 + specXAddition), 15.0f, 0);
        font.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pixelmonspawner.chance", (Object[])new Object[0]), (float)(x + 125 + percentageXAddition + specXAddition), 15.0f, 0);
    }

    @Override
    protected float[] get1Color() {
        return new float[]{255.0f, 0.0f, 0.0f};
    }

    @Override
    protected int getSize() {
        return this.gui.getPokemonListCount();
    }

    @Override
    protected boolean isSelected(int element) {
        return this.gui.list.selectedElement == element;
    }

    @Override
    protected Color getSelectionColor() {
        return new Color(128, 128, 128);
    }
}

