/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker.ribbon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.ribbon.RibbonButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetDisplayRibbonPacket;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class PokeCheckerRibbonsScreen
extends PokeCheckerScreen {
    private int page = 0;

    public PokeCheckerRibbonsScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int dispC = 0;
        int imgSize = 25;
        int cols = 6;
        int pos = 0;
        for (Ribbon t : this.pokemon.getRibbons()) {
            if (pos / 24 == this.page) {
                int y = imgSize * (dispC / cols);
                int x = 62 + imgSize * (dispC % cols);
                this.func_230480_a_((Widget)new RibbonButton(this.guiLeft + x, this.guiTop + y, 16, 16, StringTextComponent.field_240750_d_, button -> {
                    if (Objects.equals(t, this.pokemon.getDisplayedRibbon())) {
                        NetworkHelper.sendToServer(new SetDisplayRibbonPacket(this.position, this.pokemon.getUUID(), null));
                    } else {
                        NetworkHelper.sendToServer(new SetDisplayRibbonPacket(this.position, this.pokemon.getUUID(), t));
                    }
                }, t, ribbon -> Objects.equals(ribbon, this.pokemon.getDisplayedRibbon())));
                if (++dispC / cols == 4) break;
            }
            ++pos;
        }
        if (this.page != 0) {
            this.func_230480_a_((Widget)new ImageButton(0, this.guiLeft + 62, this.guiTop - 24, 24, 24, Resources.LEFT, 1.0f, 1.0f, 1.0f, button -> {
                --this.page;
                this.func_231160_c_();
            }));
        }
        if (this.page != this.pokemon.getRibbons().size() / 24) {
            this.func_230480_a_((Widget)new ImageButton(0, this.guiLeft + this.xSize, this.guiTop - 24, 24, 24, Resources.RIGHT, 1.0f, 1.0f, 1.0f, button -> {
                ++this.page;
                this.func_231160_c_();
            }));
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.summaryRibbons);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.xSize) / 2 - 40, (this.field_230709_l_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrix, int mouseX, int mouseY) {
        if (!this.pokemon.isEgg()) {
            PokeCheckerRibbonsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel()), (int)10, (int)-14, (int)0xFFFFFF);
            PokeCheckerRibbonsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex()), (int)-30, (int)-14, (int)0xFFFFFF);
            if (this.pokemon.getDisplayedRibbon() != null) {
                ScreenHelper.drawSquashedString(matrix, this.field_230706_i_.field_71466_p, this.pokemon.getDisplayedRibbon().getRibbonData().getTitle(), false, 115.0f, -33.0f, 112.0f, 0xFFFFFF, true);
                ITextComponent title = this.pokemon.getDisplayNameWithRibbon();
                int strWidth = Math.min(115, this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)title));
                ScreenHelper.drawSquashedString(matrix, this.field_230706_i_.field_71466_p, title, false, 115.0f, (float)(207 - strWidth), 112.0f, 0xFFAA00, true);
                ScreenHelper.drawSplitString(matrix, this.pokemon.getDisplayedRibbon().getRibbonData().getDescription(), -30, 128, 235, 0xFFFFFF);
            }
        } else {
            PokeCheckerRibbonsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???"), (int)10, (int)-14, (int)0xFFFFFF);
            PokeCheckerRibbonsScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???"), (int)-30, (int)-14, (int)0xFFFFFF);
        }
        this.drawBasePokemonInfo(matrix);
    }
}

